/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMClientRequestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OMClientRequestUtils.class);

    private OMClientRequestUtils() {
    }

    public static void checkClientRequestPrecondition(BucketLayout dbBucketLayout, BucketLayout reqClassBucketLayout) throws OMException {
        if (dbBucketLayout.isFileSystemOptimized() != reqClassBucketLayout.isFileSystemOptimized()) {
            String errMsg = "BucketLayout mismatch. DB BucketLayout " + dbBucketLayout + " and OMRequestClass BucketLayout " + reqClassBucketLayout;
            LOG.error(errMsg);
            throw new OMException(errMsg, OMException.ResultCodes.INTERNAL_ERROR);
        }
    }

    public static boolean isSnapshotBucket(OMMetadataManager omMetadataManager, OmKeyInfo keyInfo) throws IOException {
        String dbSnapshotBucketKey = String.valueOf(omMetadataManager.getBucketKey(keyInfo.getVolumeName(), keyInfo.getBucketName())) + "/";
        return OMClientRequestUtils.checkInSnapshotCache(omMetadataManager, dbSnapshotBucketKey) || OMClientRequestUtils.checkInSnapshotDB(omMetadataManager, dbSnapshotBucketKey);
    }

    private static boolean checkInSnapshotDB(OMMetadataManager omMetadataManager, String dbSnapshotBucketKey) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TableIterator iterator = omMetadataManager.getSnapshotInfoTable().iterator();){
            iterator.seek((Object)dbSnapshotBucketKey);
            boolean bl = iterator.hasNext() && ((String)((Table.KeyValue)iterator.next()).getKey()).startsWith(dbSnapshotBucketKey);
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean checkInSnapshotCache(OMMetadataManager omMetadataManager, String dbSnapshotBucketKey) {
        Iterator cacheIter = omMetadataManager.getSnapshotInfoTable().cacheIterator();
        while (cacheIter.hasNext()) {
            Map.Entry cacheKeyValue = (Map.Entry)cacheIter.next();
            String cacheKey = (String)((CacheKey)cacheKeyValue.getKey()).getCacheKey();
            SnapshotInfo cacheValue = (SnapshotInfo)((CacheValue)cacheKeyValue.getValue()).getCacheValue();
            if (!cacheKey.startsWith(dbSnapshotBucketKey) || cacheValue == null) continue;
            return true;
        }
        return false;
    }
}

