/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMDirectoriesPurgeResponseWithFSO;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMDirectoriesPurgeRequestWithFSO
extends OMKeyRequest {
    public OMDirectoriesPurgeRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, BucketLayout.FILE_SYSTEM_OPTIMIZED);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        block12: {
            purgeDirsRequest = this.getOmRequest().getPurgeDirectoriesRequest();
            fromSnapshot = purgeDirsRequest.hasSnapshotTableKey() != false ? purgeDirsRequest.getSnapshotTableKey() : null;
            purgeRequests = purgeDirsRequest.getDeletedPathList();
            fromSnapshotInfo = null;
            lockSet = new HashSet<Pair>();
            volBucketInfoMap = new HashMap<Pair<String, String>, OmBucketInfo>();
            omMetadataManager = ozoneManager.getMetadataManager();
            try {
                try {
                    if (fromSnapshot != null) {
                        fromSnapshotInfo = SnapshotUtils.getSnapshotInfo(ozoneManager, fromSnapshot);
                    }
                    for (OzoneManagerProtocolProtos.PurgePathRequest path : purgeRequests) {
                        for (OzoneManagerProtocolProtos.KeyInfo key : path.getMarkDeletedSubDirsList()) {
                            keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)key);
                            volumeName = keyInfo.getVolumeName();
                            volBucketPair = Pair.of((Object)volumeName, (Object)(bucketName = keyInfo.getBucketName()));
                            if (!lockSet.contains(volBucketPair)) {
                                omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                                lockSet.add(volBucketPair);
                            }
                            if ((omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName)) == null || omBucketInfo.getObjectID() != path.getBucketId()) continue;
                            omBucketInfo.incrUsedNamespace(-1L);
                            ozoneDbKey = omMetadataManager.getOzonePathKey(path.getVolumeId(), path.getBucketId(), keyInfo.getParentObjectID(), keyInfo.getFileName());
                            omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)ozoneDbKey), CacheValue.get((long)trxnLogIndex));
                            volBucketInfoMap.putIfAbsent((Pair<String, String>)volBucketPair, omBucketInfo);
                        }
                        for (OzoneManagerProtocolProtos.KeyInfo key : path.getDeletedSubFilesList()) {
                            keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)key);
                            volumeName = keyInfo.getVolumeName();
                            volBucketPair = Pair.of((Object)volumeName, (Object)(bucketName = keyInfo.getBucketName()));
                            if (!lockSet.contains(volBucketPair)) {
                                omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                                lockSet.add(volBucketPair);
                            }
                            if ((omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName)) == null || omBucketInfo.getObjectID() != path.getBucketId()) continue;
                            omBucketInfo.incrUsedBytes(-OMDirectoriesPurgeRequestWithFSO.sumBlockLengths(keyInfo));
                            omBucketInfo.incrUsedNamespace(-1L);
                            ozoneDbKey = omMetadataManager.getOzonePathKey(path.getVolumeId(), path.getBucketId(), keyInfo.getParentObjectID(), keyInfo.getFileName());
                            omMetadataManager.getFileTable().addCacheEntry(new CacheKey((Object)ozoneDbKey), CacheValue.get((long)trxnLogIndex));
                            volBucketInfoMap.putIfAbsent((Pair<String, String>)volBucketPair, omBucketInfo);
                        }
                    }
                    break block12;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            catch (Throwable var21_21) {
                lockSet.stream().forEach((Consumer<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.apache.hadoop.ozone.om.OMMetadataManager org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)V)((OMMetadataManager)omMetadataManager));
                ** for (entry : volBucketInfoMap.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                entry.setValue(((OmBucketInfo)entry.getValue()).copyObject());
                continue;
            }
lbl56:
            // 1 sources

            throw var21_21;
        }
        lockSet.stream().forEach((Consumer<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.apache.hadoop.ozone.om.OMMetadataManager org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)V)((OMMetadataManager)omMetadataManager));
        for (Map.Entry<K, OmBucketInfo> entry : volBucketInfoMap.entrySet()) {
            entry.setValue(((OmBucketInfo)entry.getValue()).copyObject());
        }
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        omClientResponse = new OMDirectoriesPurgeResponseWithFSO(omResponse.build(), purgeRequests, ozoneManager.isRatisEnabled(), this.getBucketLayout(), volBucketInfoMap, fromSnapshotInfo);
        return omClientResponse;
    }

    private static /* synthetic */ void lambda$0(OMMetadataManager oMMetadataManager, Pair e) {
        OMLockDetails oMLockDetails = oMMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{(String)e.getKey(), (String)e.getValue()});
    }
}

