/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyPurgeResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyPurgeRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyPurgeRequest.class);

    public OMKeyPurgeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OzoneManagerProtocolProtos.PurgeKeysRequest purgeKeysRequest = this.getOmRequest().getPurgeKeysRequest();
        List bucketDeletedKeysList = purgeKeysRequest.getDeletedKeysList();
        List keysToUpdateList = purgeKeysRequest.getKeysToUpdateList();
        String fromSnapshot = purgeKeysRequest.hasSnapshotTableKey() ? purgeKeysRequest.getSnapshotTableKey() : null;
        ArrayList<String> keysToBePurgedList = new ArrayList<String>();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OMKeyPurgeResponse omClientResponse = null;
        for (OzoneManagerProtocolProtos.DeletedKeys bucketWithDeleteKeys : bucketDeletedKeysList) {
            for (String deletedKey : bucketWithDeleteKeys.getKeysList()) {
                keysToBePurgedList.add(deletedKey);
            }
        }
        try {
            SnapshotInfo fromSnapshotInfo = null;
            if (fromSnapshot != null) {
                fromSnapshotInfo = SnapshotUtils.getSnapshotInfo(ozoneManager, fromSnapshot);
            }
            omClientResponse = new OMKeyPurgeResponse(omResponse.build(), keysToBePurgedList, fromSnapshotInfo, keysToUpdateList);
        }
        catch (IOException ex) {
            omClientResponse = new OMKeyPurgeResponse(this.createErrorOMResponse(omResponse, ex));
        }
        return omClientResponse;
    }
}

