/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAclRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMKeyAclRequestWithFSO
extends OMKeyAclRequest {
    public OMKeyAclRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omReq, BucketLayout bucketLayout) {
        super(omReq);
        this.setBucketLayout(bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMClientRequest.Result result;
        boolean operationResult;
        Exception exception;
        OMClientResponse omClientResponse;
        block20: {
            OmKeyInfo omKeyInfo = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            String key = null;
            operationResult = false;
            result = null;
            try {
                try {
                    ObjectParser objectParser = new ObjectParser(this.getPath(), OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY);
                    ResolvedBucket resolvedBucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)objectParser.getVolume(), (Object)objectParser.getBucket()));
                    volume = resolvedBucket.realVolume();
                    bucket = resolvedBucket.realBucket();
                    key = objectParser.getKey();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                    lockAcquired = this.getOmLockDetails().isLockAcquired();
                    OzoneFileStatus keyStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volume, bucket, key, 0L, ozoneManager.getDefaultReplicationConfig());
                    if (keyStatus == null) {
                        throw new OMException("Key not found. Key:" + key, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo = keyStatus.getKeyInfo();
                    long volumeId = omMetadataManager.getVolumeId(volume);
                    long bucketId = omMetadataManager.getBucketId(volume, bucket);
                    String dbKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName());
                    boolean isDirectory = keyStatus.isDirectory();
                    operationResult = this.apply(omKeyInfo, trxnLogIndex);
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    long modificationTime = omKeyInfo.getModificationTime();
                    if (this.getOmRequest().getAddAclRequest().hasObj() && operationResult) {
                        modificationTime = this.getOmRequest().getAddAclRequest().getModificationTime();
                    } else if (this.getOmRequest().getSetAclRequest().hasObj()) {
                        modificationTime = this.getOmRequest().getSetAclRequest().getModificationTime();
                    } else if (this.getOmRequest().getRemoveAclRequest().hasObj() && operationResult) {
                        modificationTime = this.getOmRequest().getRemoveAclRequest().getModificationTime();
                    }
                    omKeyInfo.setModificationTime(modificationTime);
                    if (isDirectory) {
                        Table dirTable = omMetadataManager.getDirectoryTable();
                        dirTable.addCacheEntry(new CacheKey((Object)dbKey), CacheValue.get((long)trxnLogIndex, (Object)OMFileRequest.getDirectoryInfo(omKeyInfo)));
                    } else {
                        omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbKey), CacheValue.get((long)trxnLogIndex, (Object)omKeyInfo));
                    }
                    omClientResponse = this.onSuccess(omResponse, omKeyInfo, operationResult, isDirectory, volumeId, bucketId);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, exception);
                    if (lockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (lockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (lockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        OzoneObj obj = this.getObject();
        Map auditMap = obj.toAuditMap();
        this.onComplete(result, operationResult, exception, trxnLogIndex, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResp, Exception exception) {
        return new OMKeyAclResponseWithFSO(this.createErrorOMResponse(omResp, exception), this.getBucketLayout());
    }

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmKeyInfo var2, boolean var3, boolean var4, long var5, long var7);
}

