/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl.prefix;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMPrefixAclRequest
extends OMClientRequest {
    public OMPrefixAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMClientRequest.Result result;
        boolean opResult;
        Exception exception;
        OMClientResponse omClientResponse;
        block17: {
            OmPrefixInfo omPrefixInfo = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            String key = null;
            PrefixManagerImpl.OMPrefixAclOpResult operationResult = null;
            opResult = false;
            result = null;
            PrefixManagerImpl prefixManager = (PrefixManagerImpl)ozoneManager.getPrefixManager();
            try {
                try {
                    String prefixPath = this.getOzoneObj().getPath();
                    ObjectParser objectParser = new ObjectParser(prefixPath, OzoneManagerProtocolProtos.OzoneObj.ObjectType.PREFIX);
                    volume = objectParser.getVolume();
                    bucket = objectParser.getBucket();
                    key = objectParser.getKey();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.PREFIX, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath}));
                    lockAcquired = this.getOmLockDetails().isLockAcquired();
                    omPrefixInfo = (OmPrefixInfo)omMetadataManager.getPrefixTable().get((Object)prefixPath);
                    try {
                        operationResult = this.apply(prefixManager, omPrefixInfo, trxnLogIndex);
                    }
                    catch (IOException iOException) {
                        operationResult = new PrefixManagerImpl.OMPrefixAclOpResult(null, false);
                    }
                    omPrefixInfo = operationResult.getOmPrefixInfo();
                    if (omPrefixInfo == null) {
                        throw new OMException("No prefix info for the prefix path: " + prefixPath, OMException.ResultCodes.PREFIX_NOT_FOUND);
                    }
                    omPrefixInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    if (this.getOmRequest().hasRemoveAclRequest() && omPrefixInfo.getAcls().size() == 0) {
                        omMetadataManager.getPrefixTable().addCacheEntry(new CacheKey((Object)prefixPath), CacheValue.get((long)trxnLogIndex));
                    } else {
                        omMetadataManager.getPrefixTable().addCacheEntry(new CacheKey((Object)prefixPath), CacheValue.get((long)trxnLogIndex, (Object)omPrefixInfo));
                    }
                    opResult = operationResult.isSuccess();
                    omClientResponse = this.onSuccess(omResponse, omPrefixInfo, opResult);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, exception);
                    if (lockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (lockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (lockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        OzoneObj obj = this.getOzoneObj();
        Map auditMap = obj.toAuditMap();
        this.onComplete(opResult, exception, ozoneManager.getMetrics(), result, trxnLogIndex, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    abstract OzoneObj getOzoneObj();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmPrefixInfo var2, boolean var3);

    abstract OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder var1, Exception var2);

    abstract void onComplete(boolean var1, Exception var2, OMMetrics var3, OMClientRequest.Result var4, long var5, AuditLogger var7, Map<String, String> var8);

    abstract PrefixManagerImpl.OMPrefixAclOpResult apply(PrefixManagerImpl var1, OmPrefixInfo var2, long var3) throws IOException;
}

