/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.security;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.security.OMRenewDelegationTokenResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRenewDelegationTokenRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMRenewDelegationTokenRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMRenewDelegationTokenRequest.class);
    }

    public OMRenewDelegationTokenRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        long renewTime;
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.OMRequest request = super.preExecute(ozoneManager);
        SecurityProtos.RenewDelegationTokenRequestProto renewDelegationTokenRequest = request.getRenewDelegationTokenRequest();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = null;
        try {
            Token token = OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)renewDelegationTokenRequest.getToken());
            auditMap = OzoneManagerUtils.buildTokenAuditMap((Token<OzoneTokenIdentifier>)token);
            OzoneTokenIdentifier ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])token.getIdentifier());
            auditMap.put("renewer", ozoneTokenIdentifier.getRenewer() == null ? "" : ozoneTokenIdentifier.getRenewer().toString());
            renewTime = ozoneManager.renewDelegationToken((Token<OzoneTokenIdentifier>)token);
        }
        catch (IOException ioe) {
            this.auditLog(auditLogger, this.buildAuditMessage(OMAction.RENEW_DELEGATION_TOKEN, auditMap, ioe, request.getUserInfo()));
            throw ioe;
        }
        OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto.Builder renewResponse = OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto.newBuilder();
        renewResponse.setResponse(SecurityProtos.RenewDelegationTokenResponseProto.newBuilder().setNewExpiryTime(renewTime));
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdatedRenewDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateRenewDelegationTokenRequest.newBuilder().setRenewDelegationTokenRequest(renewDelegationTokenRequest).setRenewDelegationTokenResponse(renewResponse)).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.UpdateRenewDelegationTokenRequest updateRenewDelegationTokenRequest = this.getOmRequest().getUpdatedRenewDelegationTokenRequest();
        Token ozoneTokenIdentifierToken = OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)updateRenewDelegationTokenRequest.getRenewDelegationTokenRequest().getToken());
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = OzoneManagerUtils.buildTokenAuditMap((Token<OzoneTokenIdentifier>)ozoneTokenIdentifierToken);
        long renewTime = updateRenewDelegationTokenRequest.getRenewDelegationTokenResponse().getResponse().getNewExpiryTime();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OMRenewDelegationTokenResponse omClientResponse = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        Exception exception = null;
        try {
            OzoneTokenIdentifier ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])ozoneTokenIdentifierToken.getIdentifier());
            auditMap.put("renewer", ozoneTokenIdentifier.getRenewer() == null ? "" : ozoneTokenIdentifier.getRenewer().toString());
            ozoneManager.getDelegationTokenMgr().updateRenewToken((Token<OzoneTokenIdentifier>)ozoneTokenIdentifierToken, ozoneTokenIdentifier, renewTime);
            omMetadataManager.getDelegationTokenTable().addCacheEntry(new CacheKey((Object)ozoneTokenIdentifier), CacheValue.get((long)transactionLogIndex, (Object)renewTime));
            omClientResponse = new OMRenewDelegationTokenResponse(ozoneTokenIdentifier, renewTime, omResponse.setRenewDelegationTokenResponse(updateRenewDelegationTokenRequest.getRenewDelegationTokenResponse()).build());
        }
        catch (IOException | InvalidPathException ex) {
            LOG.error("Error in Updating Renew DelegationToken {}", (Object)ozoneTokenIdentifierToken, (Object)ex);
            exception = ex;
            omClientResponse = new OMRenewDelegationTokenResponse(null, -1L, this.createErrorOMResponse(omResponse, exception));
        }
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.RENEW_DELEGATION_TOKEN, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated renew delegation token in-memory map: {} with expiry time {}", (Object)ozoneTokenIdentifierToken, (Object)renewTime);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMRenewDelegationTokenRequest.java", OMRenewDelegationTokenRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.security.OMRenewDelegationTokenRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 62);
    }
}

