/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.UUID;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotCreateResponse;
import org.apache.hadoop.ozone.om.snapshot.RequireSnapshotFeatureState;
import org.apache.hadoop.ozone.om.snapshot.RequireSnapshotFeatureStateAspect;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSnapshotCreateRequest
extends OMClientRequest {
    private static final Logger LOG;
    private final String snapshotPath;
    private final String volumeName;
    private final String bucketName;
    private final String snapshotName;
    private final SnapshotInfo snapshotInfo;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMSnapshotCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMSnapshotCreateRequest.class);
    }

    public OMSnapshotCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
        OzoneManagerProtocolProtos.CreateSnapshotRequest createSnapshotRequest = omRequest.getCreateSnapshotRequest();
        this.volumeName = createSnapshotRequest.getVolumeName();
        this.bucketName = createSnapshotRequest.getBucketName();
        UUID snapshotId = createSnapshotRequest.hasSnapshotId() ? HddsUtils.fromProtobuf((HddsProtos.UUID)createSnapshotRequest.getSnapshotId()) : null;
        String possibleName = createSnapshotRequest.getSnapshotName();
        this.snapshotInfo = SnapshotInfo.newInstance((String)this.volumeName, (String)this.bucketName, (String)possibleName, (UUID)snapshotId, (long)createSnapshotRequest.getCreationTime());
        this.snapshotName = this.snapshotInfo.getName();
        this.snapshotPath = this.snapshotInfo.getSnapshotPath();
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    @RequireSnapshotFeatureState(value=true)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        RequireSnapshotFeatureStateAspect.aspectOf().checkFeatureState(joinPoint);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OmUtils.validateSnapshotName((String)this.snapshotName);
        UserGroupInformation ugi = this.createUGIForApi();
        String bucketOwner = ozoneManager.getBucketOwner(this.volumeName, this.bucketName, IAccessAuthorizer.ACLType.READ, OzoneObj.ResourceType.BUCKET);
        if (!ozoneManager.isAdmin(ugi) && !ozoneManager.isOwner(ugi, bucketOwner)) {
            throw new OMException("Only bucket owners and Ozone admins can create snapshots", OMException.ResultCodes.PERMISSION_DENIED);
        }
        return omRequest.toBuilder().setCreateSnapshotRequest(omRequest.getCreateSnapshotRequest().toBuilder().setSnapshotId(HddsUtils.toProtobuf((UUID)UUID.randomUUID())).setCreationTime(Time.now()).build()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMClientResponse omClientResponse;
        Exception exception;
        OMMetrics omMetrics;
        block17: {
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumSnapshotCreates();
            boolean acquiredBucketLock = false;
            boolean acquiredSnapshotLock = false;
            exception = null;
            OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            String key = this.snapshotInfo.getTableKey();
            try {
                try {
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                    acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.SNAPSHOT_LOCK, new String[]{this.volumeName, this.bucketName, this.snapshotName}));
                    acquiredSnapshotLock = this.getOmLockDetails().isLockAcquired();
                    if (omMetadataManager.getSnapshotInfoTable().isExist((Object)key)) {
                        LOG.debug("Snapshot '{}' already exists under '{}'", (Object)key, (Object)this.snapshotPath);
                        throw new OMException("Snapshot already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                    long dbLatestSequenceNumber = ((RDBStore)omMetadataManager.getStore()).getDb().getLatestSequenceNumber();
                    this.snapshotInfo.setDbTxSequenceNumber(dbLatestSequenceNumber);
                    OmBucketInfo omBucketInfo = this.getBucketInfo(omMetadataManager, this.volumeName, this.bucketName);
                    this.snapshotInfo.setReferencedReplicatedSize(omBucketInfo.getUsedBytes());
                    this.snapshotInfo.setReferencedSize(this.estimateBucketDataSize(omBucketInfo));
                    this.addSnapshotInfoToSnapshotChainAndCache(omMetadataManager, transactionLogIndex);
                    omResponse.setCreateSnapshotResponse(OzoneManagerProtocolProtos.CreateSnapshotResponse.newBuilder().setSnapshotInfo(this.snapshotInfo.getProtobuf()));
                    omClientResponse = new OMSnapshotCreateResponse(omResponse.build(), this.snapshotInfo);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMSnapshotCreateResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredSnapshotLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.SNAPSHOT_LOCK, new String[]{this.volumeName, this.bucketName, this.snapshotName}));
                    }
                    if (acquiredBucketLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (acquiredSnapshotLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.SNAPSHOT_LOCK, new String[]{this.volumeName, this.bucketName, this.snapshotName}));
                }
                if (acquiredBucketLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredSnapshotLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.SNAPSHOT_LOCK, new String[]{this.volumeName, this.bucketName, this.snapshotName}));
            }
            if (acquiredBucketLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.CREATE_SNAPSHOT, this.snapshotInfo.toAuditMap(), exception, userInfo));
        if (exception == null) {
            LOG.info("Created snapshot: '{}' with snapshotId: '{}' under path '{}'", new Object[]{this.snapshotName, this.snapshotInfo.getSnapshotId(), this.snapshotPath});
            omMetrics.incNumSnapshotActive();
        } else {
            omMetrics.incNumSnapshotCreateFails();
            LOG.error("Failed to create snapshot '{}' with snapshotId: '{}' under path '{}'", new Object[]{this.snapshotName, this.snapshotInfo.getSnapshotId(), this.snapshotPath});
        }
        return omClientResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSnapshotInfoToSnapshotChainAndCache(OmMetadataManagerImpl omMetadataManager, long transactionLogIndex) throws IOException {
        SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
        synchronized (snapshotChainManager) {
            SnapshotChainManager snapshotChainManager2 = omMetadataManager.getSnapshotChainManager();
            UUID latestPathSnapshot = snapshotChainManager2.getLatestPathSnapshotId(this.snapshotPath);
            UUID latestGlobalSnapshot = snapshotChainManager2.getLatestGlobalSnapshotId();
            this.snapshotInfo.setPathPreviousSnapshotId(latestPathSnapshot);
            this.snapshotInfo.setGlobalPreviousSnapshotId(latestGlobalSnapshot);
            try {
                snapshotChainManager2.addSnapshot(this.snapshotInfo);
                omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)this.snapshotInfo.getTableKey()), CacheValue.get((long)transactionLogIndex, (Object)this.snapshotInfo));
            }
            catch (IOException exception) {
                this.removeSnapshotInfoFromSnapshotChainManager(snapshotChainManager2, this.snapshotInfo);
                throw new IOException(exception.getMessage(), exception);
            }
        }
    }

    private void removeSnapshotInfoFromSnapshotChainManager(SnapshotChainManager snapshotChainManager, SnapshotInfo info) {
        try {
            snapshotChainManager.deleteSnapshot(info);
        }
        catch (IOException exception) {
            LOG.error("Failed to remove snapshot: {} from SnapshotChainManager.", (Object)info, (Object)exception);
        }
    }

    protected OmBucketInfo getBucketInfo(OMMetadataManager omMetadataManager, String volume, String bucket) {
        String bucketKey = omMetadataManager.getBucketKey(volume, bucket);
        CacheValue value = omMetadataManager.getBucketTable().getCacheValue(new CacheKey((Object)bucketKey));
        return value != null ? (OmBucketInfo)value.getCacheValue() : null;
    }

    private long estimateBucketDataSize(OmBucketInfo bucketInfo) {
        ReplicationConfig rc;
        DefaultReplicationConfig defRC = bucketInfo.getDefaultReplicationConfig();
        if (defRC == null) {
            rc = ReplicationConfig.getDefault((ConfigurationSource)new OzoneConfiguration());
            LOG.warn("DefaultReplicationConfig is not correctly set in OmBucketInfo for volume '{}' bucket '{}'. Falling back to config default '{}'", new Object[]{bucketInfo.getVolumeName(), bucketInfo.getBucketName(), rc});
        } else {
            rc = defRC.getReplicationConfig();
        }
        return QuotaUtil.getDataSize((long)bucketInfo.getUsedBytes(), (ReplicationConfig)rc);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMSnapshotCreateRequest.java", OMSnapshotCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 103);
    }
}

