/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotPurgeResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSnapshotPurgeRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMSnapshotPurgeRequest.class);
    private final Map<String, SnapshotInfo> updatedSnapshotInfos = new HashMap<String, SnapshotInfo>();

    public OMSnapshotPurgeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMMetrics omMetrics = ozoneManager.getMetrics();
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
        OMSnapshotPurgeResponse omClientResponse = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OzoneManagerProtocolProtos.SnapshotPurgeRequest snapshotPurgeRequest = this.getOmRequest().getSnapshotPurgeRequest();
        try {
            List snapshotDbKeys = snapshotPurgeRequest.getSnapshotDBKeysList();
            for (String snapTableKey : snapshotDbKeys) {
                SnapshotInfo fromSnapshot = this.getUpdatedSnapshotInfo(snapTableKey, omMetadataManager);
                if (fromSnapshot == null) {
                    LOG.warn("The snapshot {} is not longer in snapshot table, It maybe removed in the previous Snapshot purge request.", (Object)snapTableKey);
                    continue;
                }
                SnapshotInfo nextSnapshot = SnapshotUtils.getNextActiveSnapshot(fromSnapshot, snapshotChainManager, ozoneManager);
                this.updateSnapshotInfoAndCache(nextSnapshot, omMetadataManager, trxnLogIndex);
                this.updateSnapshotChainAndCache(omMetadataManager, fromSnapshot, trxnLogIndex);
                omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)fromSnapshot.getTableKey()), CacheValue.get((long)trxnLogIndex));
            }
            omClientResponse = new OMSnapshotPurgeResponse(omResponse.build(), snapshotDbKeys, this.updatedSnapshotInfos);
            omMetrics.incNumSnapshotPurges();
            LOG.info("Successfully executed snapshotPurgeRequest: {{}} along with updating snapshots:{}.", (Object)snapshotPurgeRequest, this.updatedSnapshotInfos);
        }
        catch (IOException ex) {
            omClientResponse = new OMSnapshotPurgeResponse(this.createErrorOMResponse(omResponse, ex));
            omMetrics.incNumSnapshotPurgeFails();
            LOG.error("Failed to execute snapshotPurgeRequest:{{}}.", (Object)snapshotPurgeRequest, (Object)ex);
        }
        return omClientResponse;
    }

    private void updateSnapshotInfoAndCache(SnapshotInfo snapInfo, OmMetadataManagerImpl omMetadataManager, long trxnLogIndex) throws IOException {
        if (snapInfo != null) {
            snapInfo.setDeepClean(false);
            omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)snapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)snapInfo));
            this.updatedSnapshotInfos.put(snapInfo.getTableKey(), snapInfo);
        }
    }

    private void updateSnapshotChainAndCache(OmMetadataManagerImpl metadataManager, SnapshotInfo snapInfo, long trxnLogIndex) throws IOException {
        SnapshotInfo nextGlobalSnapInfo;
        SnapshotInfo nextPathSnapInfo;
        boolean hasNextGlobalSnapshot;
        boolean hasNextPathSnapshot;
        if (snapInfo == null) {
            return;
        }
        SnapshotChainManager snapshotChainManager = metadataManager.getSnapshotChainManager();
        try {
            hasNextPathSnapshot = snapshotChainManager.hasNextPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId());
            hasNextGlobalSnapshot = snapshotChainManager.hasNextGlobalSnapshot(snapInfo.getSnapshotId());
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        String nextPathSnapshotKey = null;
        if (hasNextPathSnapshot) {
            UUID nextPathSnapshotId = snapshotChainManager.nextPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId());
            nextPathSnapshotKey = snapshotChainManager.getTableKey(nextPathSnapshotId);
        }
        String nextGlobalSnapshotKey = null;
        if (hasNextGlobalSnapshot) {
            UUID nextGlobalSnapshotId = snapshotChainManager.nextGlobalSnapshot(snapInfo.getSnapshotId());
            nextGlobalSnapshotKey = snapshotChainManager.getTableKey(nextGlobalSnapshotId);
        }
        SnapshotInfo snapshotInfo = nextPathSnapInfo = nextPathSnapshotKey != null ? this.getUpdatedSnapshotInfo(nextPathSnapshotKey, metadataManager) : null;
        if (nextPathSnapInfo != null) {
            nextPathSnapInfo.setPathPreviousSnapshotId(snapInfo.getPathPreviousSnapshotId());
            metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)nextPathSnapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)nextPathSnapInfo));
        }
        SnapshotInfo snapshotInfo2 = nextGlobalSnapInfo = nextGlobalSnapshotKey != null ? this.getUpdatedSnapshotInfo(nextGlobalSnapshotKey, metadataManager) : null;
        if (nextGlobalSnapInfo != null) {
            nextGlobalSnapInfo.setGlobalPreviousSnapshotId(snapInfo.getGlobalPreviousSnapshotId());
            metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)nextGlobalSnapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)nextGlobalSnapInfo));
        }
        snapshotChainManager.deleteSnapshot(snapInfo);
    }

    private SnapshotInfo getUpdatedSnapshotInfo(String snapshotTableKey, OMMetadataManager omMetadataManager) throws IOException {
        SnapshotInfo snapshotInfo = this.updatedSnapshotInfos.get(snapshotTableKey);
        if (snapshotInfo == null) {
            snapshotInfo = (SnapshotInfo)omMetadataManager.getSnapshotInfoTable().get((Object)snapshotTableKey);
            this.updatedSnapshotInfos.put(snapshotTableKey, snapshotInfo);
        }
        return snapshotInfo;
    }
}

