/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.validation;

import com.google.protobuf.ServiceException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.request.validation.ValidatorRegistry;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidations {
    static final Logger LOG = LoggerFactory.getLogger(RequestValidations.class);
    private static final String DEFAULT_PACKAGE = "org.apache.hadoop.ozone";
    private String validationsPackageName = "org.apache.hadoop.ozone";
    private ValidationContext context = null;
    private ValidatorRegistry registry = null;

    public synchronized RequestValidations fromPackage(String packageName) {
        this.validationsPackageName = packageName;
        return this;
    }

    public RequestValidations withinContext(ValidationContext validationContext) {
        this.context = validationContext;
        return this;
    }

    public synchronized RequestValidations load() {
        this.registry = new ValidatorRegistry(this.validationsPackageName);
        return this;
    }

    public OzoneManagerProtocolProtos.OMRequest validateRequest(OzoneManagerProtocolProtos.OMRequest request) throws Exception {
        List<Method> validations = this.registry.validationsFor(this.conditions(request), request.getCmdType(), RequestProcessingPhase.PRE_PROCESS);
        OzoneManagerProtocolProtos.OMRequest validatedRequest = request.toBuilder().build();
        try {
            for (Method m : validations) {
                LOG.debug("Running the {} request pre-process validation from {}.{}", new Object[]{m.getName(), m.getDeclaringClass().getPackage().getName(), m.getDeclaringClass().getSimpleName()});
                validatedRequest = (OzoneManagerProtocolProtos.OMRequest)m.invoke(null, validatedRequest, this.context);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof OMException) {
                throw (OMException)e.getCause();
            }
            throw new ServiceException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException((Throwable)e);
        }
        return validatedRequest;
    }

    public OzoneManagerProtocolProtos.OMResponse validateResponse(OzoneManagerProtocolProtos.OMRequest request, OzoneManagerProtocolProtos.OMResponse response) throws ServiceException {
        List<Method> validations = this.registry.validationsFor(this.conditions(request), request.getCmdType(), RequestProcessingPhase.POST_PROCESS);
        OzoneManagerProtocolProtos.OMResponse validatedResponse = response.toBuilder().build();
        try {
            for (Method m : validations) {
                LOG.debug("Running the {} request post-process validation from {}.{}", new Object[]{m.getName(), m.getDeclaringClass().getPackage().getName(), m.getDeclaringClass().getSimpleName()});
                validatedResponse = (OzoneManagerProtocolProtos.OMResponse)m.invoke(null, request, validatedResponse, this.context);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ServiceException((Throwable)e);
        }
        return validatedResponse;
    }

    private List<ValidationCondition> conditions(OzoneManagerProtocolProtos.OMRequest request) {
        return Arrays.stream(ValidationCondition.values()).filter(c -> c.shouldApply(request, this.context)).collect(Collectors.toList());
    }
}

