/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.file;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"directoryTable"})
public class OMDirectoryCreateResponseWithFSO
extends OmKeyResponse {
    public static final Logger LOG = LoggerFactory.getLogger(OMDirectoryCreateResponseWithFSO.class);
    private OmDirectoryInfo dirInfo;
    private List<OmDirectoryInfo> parentDirInfos;
    private OMDirectoryCreateRequest.Result result;
    private long volumeId;
    private long bucketId;
    private OmBucketInfo bucketInfo;

    public OMDirectoryCreateResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull long volumeId, @Nonnull long bucketId, @Nonnull OmDirectoryInfo dirInfo, @Nonnull List<OmDirectoryInfo> pDirInfos, @Nonnull OMDirectoryCreateRequest.Result result, @Nonnull BucketLayout bucketLayout, @Nonnull OmBucketInfo bucketInfo) {
        super(omResponse, bucketLayout);
        this.dirInfo = dirInfo;
        this.parentDirInfos = pDirInfos;
        this.result = result;
        this.volumeId = volumeId;
        this.bucketId = bucketId;
        this.bucketInfo = bucketInfo;
    }

    public OMDirectoryCreateResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OMDirectoryCreateRequest.Result result) {
        super(omResponse);
        this.result = result;
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        this.addToDirectoryTable(omMetadataManager, batchOperation);
    }

    private void addToDirectoryTable(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.dirInfo != null) {
            if (this.parentDirInfos != null) {
                for (OmDirectoryInfo parentDirInfo : this.parentDirInfos) {
                    String parentKey = omMetadataManager.getOzonePathKey(this.volumeId, this.bucketId, parentDirInfo.getParentObjectID(), parentDirInfo.getName());
                    LOG.debug("putWithBatch parent : dir {} info : {}", (Object)parentKey, (Object)parentDirInfo);
                    omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)parentKey, (Object)parentDirInfo);
                }
            }
            String dirKey = omMetadataManager.getOzonePathKey(this.volumeId, this.bucketId, this.dirInfo.getParentObjectID(), this.dirInfo.getName());
            omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)dirKey, (Object)this.dirInfo);
            String bucketKey = omMetadataManager.getBucketKey(this.bucketInfo.getVolumeName(), this.bucketInfo.getBucketName());
            omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)bucketKey, (Object)this.bucketInfo);
        } else {
            LOG.debug("Response Status is OK, dirKeyInfo is null in OMDirectoryCreateResponseWithFSO");
        }
    }
}

