/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.file.OMFileCreateResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"directoryTable", "openFileTable", "bucketTable"})
public class OMFileCreateResponseWithFSO
extends OMFileCreateResponse {
    private List<OmDirectoryInfo> parentDirInfos;
    private long volumeId;

    public OMFileCreateResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, @Nonnull List<OmDirectoryInfo> parentDirInfos, long openKeySessionID, @Nonnull OmBucketInfo omBucketInfo, @Nonnull long volumeId) {
        super(omResponse, omKeyInfo, new ArrayList<OmKeyInfo>(), openKeySessionID, omBucketInfo);
        this.parentDirInfos = parentDirInfos;
        this.volumeId = volumeId;
    }

    public OMFileCreateResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataMgr, BatchOperation batchOp) throws IOException {
        if (this.parentDirInfos != null) {
            for (OmDirectoryInfo parentDirInfo : this.parentDirInfos) {
                String parentKey = omMetadataMgr.getOzonePathKey(this.volumeId, this.getOmBucketInfo().getObjectID(), parentDirInfo.getParentObjectID(), parentDirInfo.getName());
                if (OMKeyCreateResponse.LOG.isDebugEnabled()) {
                    OMKeyCreateResponse.LOG.debug("putWithBatch adding parent : key {} info : {}", (Object)parentKey, (Object)parentDirInfo);
                }
                omMetadataMgr.getDirectoryTable().putWithBatch(batchOp, (Object)parentKey, (Object)parentDirInfo);
            }
            String bucketKey = omMetadataMgr.getBucketKey(this.getOmBucketInfo().getVolumeName(), this.getOmBucketInfo().getBucketName());
            omMetadataMgr.getBucketTable().putWithBatch(batchOp, (Object)bucketKey, (Object)this.getOmBucketInfo());
        }
        OMFileRequest.addToOpenFileTable(omMetadataMgr, batchOp, this.getOmKeyInfo(), this.getOpenKeySessionID(), this.volumeId, this.getOmBucketInfo().getObjectID());
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

