/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"openKeyTable", "keyTable", "bucketTable"})
public class OMKeyCreateResponse
extends OmKeyResponse {
    public static final Logger LOG = LoggerFactory.getLogger(OMKeyCreateResponse.class);
    private OmKeyInfo omKeyInfo;
    private long openKeySessionID;
    private List<OmKeyInfo> parentKeyInfos;
    private OmBucketInfo omBucketInfo;

    public OMKeyCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, List<OmKeyInfo> parentKeyInfos, long openKeySessionID, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse, omBucketInfo.getBucketLayout());
        this.omKeyInfo = omKeyInfo;
        this.openKeySessionID = openKeySessionID;
        this.parentKeyInfos = parentKeyInfos;
        this.omBucketInfo = omBucketInfo;
    }

    public OMKeyCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.parentKeyInfos != null) {
            for (OmKeyInfo parentKeyInfo : this.parentKeyInfos) {
                String parentKey = omMetadataManager.getOzoneDirKey(parentKeyInfo.getVolumeName(), parentKeyInfo.getBucketName(), parentKeyInfo.getKeyName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("putWithBatch adding parent : key {} info : {}", (Object)parentKey, (Object)parentKeyInfo);
                }
                omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)parentKey, (Object)parentKeyInfo);
            }
            String bucketKey = omMetadataManager.getBucketKey(this.getOmBucketInfo().getVolumeName(), this.getOmBucketInfo().getBucketName());
            omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)bucketKey, (Object)this.getOmBucketInfo());
        }
        String openKey = omMetadataManager.getOpenKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName(), this.openKeySessionID);
        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)openKey, (Object)this.omKeyInfo);
    }

    protected long getOpenKeySessionID() {
        return this.openKeySessionID;
    }

    protected OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }

    protected OmBucketInfo getOmBucketInfo() {
        return this.omBucketInfo;
    }
}

