/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.tenant;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBUserPrincipalInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"s3SecretTable", "tenantAccessIdTable", "principalToAccessIdsTable"})
public class OMTenantAssignUserAccessIdResponse
extends OMClientResponse {
    private S3SecretValue s3SecretValue;
    private String principal;
    private String accessId;
    private OmDBAccessIdInfo omDBAccessIdInfo;
    private OmDBUserPrincipalInfo omDBUserPrincipalInfo;
    private S3SecretManager s3SecretManager;

    public OMTenantAssignUserAccessIdResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull S3SecretValue s3SecretValue, @Nonnull String principal, @Nonnull String accessId, @Nonnull OmDBAccessIdInfo omDBAccessIdInfo, @Nonnull OmDBUserPrincipalInfo omDBUserPrincipalInfo, @Nonnull S3SecretManager s3SecretManager) {
        super(omResponse);
        this.s3SecretValue = s3SecretValue;
        this.principal = principal;
        this.accessId = accessId;
        this.omDBAccessIdInfo = omDBAccessIdInfo;
        this.omDBUserPrincipalInfo = omDBUserPrincipalInfo;
        this.s3SecretManager = s3SecretManager;
    }

    public OMTenantAssignUserAccessIdResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        boolean isOk;
        boolean bl = isOk = this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK;
        if (this.s3SecretValue != null && isOk) {
            if (this.s3SecretManager.isBatchSupported()) {
                this.s3SecretManager.batcher().addWithBatch((AutoCloseable)batchOperation, this.accessId, this.s3SecretValue);
            } else {
                this.s3SecretManager.storeSecret(this.accessId, this.s3SecretValue);
            }
        }
        omMetadataManager.getTenantAccessIdTable().putWithBatch(batchOperation, (Object)this.accessId, (Object)this.omDBAccessIdInfo);
        omMetadataManager.getPrincipalToAccessIdsTable().putWithBatch(batchOperation, (Object)this.principal, (Object)this.omDBUserPrincipalInfo);
    }

    @VisibleForTesting
    public OmDBAccessIdInfo getOmDBAccessIdInfo() {
        return this.omDBAccessIdInfo;
    }

    @VisibleForTesting
    public S3SecretValue getS3Secret() {
        return this.s3SecretValue;
    }
}

