/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.volume;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;

@CleanupTableInfo(cleanupTables={"volumeTable"})
public class OMVolumeCreateResponse
extends OMClientResponse {
    private OzoneManagerStorageProtos.PersistedUserVolumeInfo userVolumeInfo;
    private OmVolumeArgs omVolumeArgs;

    public OMVolumeCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmVolumeArgs omVolumeArgs, @Nonnull OzoneManagerStorageProtos.PersistedUserVolumeInfo userVolumeInfo) {
        super(omResponse);
        this.omVolumeArgs = omVolumeArgs;
        this.userVolumeInfo = userVolumeInfo;
    }

    public OMVolumeCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String dbVolumeKey = omMetadataManager.getVolumeKey(this.omVolumeArgs.getVolume());
        String dbUserKey = omMetadataManager.getUserKey(this.omVolumeArgs.getOwnerName());
        omMetadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)dbVolumeKey, (Object)this.omVolumeArgs);
        omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)dbUserKey, (Object)this.userVolumeInfo);
    }

    @VisibleForTesting
    public OmVolumeArgs getOmVolumeArgs() {
        return this.omVolumeArgs;
    }
}

