/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class OmSnapshotUtils {
    public static final String DATA_PREFIX = "data";
    public static final String DATA_SUFFIX = "txt";

    private OmSnapshotUtils() {
    }

    public static String truncateFileName(int truncateLength, Path file) {
        return file.toString().substring(truncateLength);
    }

    @VisibleForTesting
    public static Object getINode(Path file) throws IOException {
        return Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).fileKey();
    }

    public static Path createHardLinkList(int truncateLength, Map<Path, Path> hardLinkFiles) throws IOException {
        Path data = Files.createTempFile(DATA_PREFIX, DATA_SUFFIX, new FileAttribute[0]);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Path, Path> entry : hardLinkFiles.entrySet()) {
            Path f;
            String fixedFile = OmSnapshotUtils.truncateFileName(truncateLength, entry.getValue());
            if (fixedFile.startsWith("db.checkpoints") && (f = Paths.get(fixedFile, new String[0]).getFileName()) != null) {
                fixedFile = f.toString();
            }
            sb.append(OmSnapshotUtils.truncateFileName(truncateLength, entry.getKey())).append("\t").append(fixedFile).append("\n");
        }
        Files.write(data, sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return data;
    }

    public static void createHardLinks(Path dbPath) throws IOException {
        File hardLinkFile = new File(dbPath.toString(), "hardLinkFile");
        if (hardLinkFile.exists()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<String> s = Files.lines(hardLinkFile.toPath());){
                List lines = s.collect(Collectors.toList());
                for (String l : lines) {
                    String from = l.split("\t")[1];
                    String to = l.split("\t")[0];
                    Path fullFromPath = Paths.get(dbPath.toString(), from);
                    Path fullToPath = Paths.get(dbPath.toString(), to);
                    Path parent = fullToPath.getParent();
                    if (parent != null && !parent.toFile().exists() && !parent.toFile().mkdirs()) {
                        throw new IOException("Failed to create directory: " + parent.toString());
                    }
                    Files.createLink(fullToPath, fullFromPath);
                }
                if (!hardLinkFile.delete()) {
                    throw new IOException("Failed to delete: " + hardLinkFile);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static void linkFiles(File oldDir, File newDir) throws IOException {
        List oldDirList;
        int truncateLength = oldDir.toString().length() + 1;
        Throwable throwable = null;
        Iterator iterator = null;
        try (Stream<Path> files = Files.walk(oldDir.toPath(), new FileVisitOption[0]);){
            oldDirList = files.map(Path::toString).filter(s -> !s.equals(oldDir.toString())).map(s -> s.substring(truncateLength)).sorted().collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (String s2 : oldDirList) {
            File oldFile = new File(oldDir, s2);
            File newFile = new File(newDir, s2);
            File newParent = newFile.getParentFile();
            if (!newParent.exists() && !newParent.mkdirs()) {
                throw new IOException("Directory create fails: " + newParent);
            }
            if (oldFile.isDirectory()) {
                if (newFile.mkdirs()) continue;
                throw new IOException("Directory create fails: " + newFile);
            }
            Files.createLink(newFile.toPath(), oldFile.toPath());
        }
    }
}

