/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerDoubleBuffer;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.validation.RequestValidations;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;
import org.apache.hadoop.ozone.protocolPB.RequestHandler;
import org.apache.hadoop.ozone.security.S3SecurityUtil;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.util.MetricUtil;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerProtocolServerSideTranslatorPB
implements OzoneManagerProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerProtocolServerSideTranslatorPB.class);
    private static final String OM_REQUESTS_PACKAGE = "org.apache.hadoop.ozone";
    private final OzoneManagerRatisServer omRatisServer;
    private final RequestHandler handler;
    private final boolean isRatisEnabled;
    private final OzoneManager ozoneManager;
    private final OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer;
    private final AtomicLong transactionIndex;
    private final OzoneProtocolMessageDispatcher<OzoneManagerProtocolProtos.OMRequest, OzoneManagerProtocolProtos.OMResponse, ProtocolMessageEnum> dispatcher;
    private final RequestValidations requestValidations;
    private final OMPerformanceMetrics perfMetrics;
    private boolean shouldFlushCache = true;
    private OzoneManagerProtocolProtos.OMRequest lastRequestToSubmit;

    public OzoneManagerProtocolServerSideTranslatorPB(OzoneManager impl, OzoneManagerRatisServer ratisServer, ProtocolMessageMetrics<ProtocolMessageEnum> metrics, boolean enableRatis, long lastTransactionIndexForNonRatis) {
        this.ozoneManager = impl;
        this.perfMetrics = impl.getPerfMetrics();
        this.isRatisEnabled = enableRatis;
        this.transactionIndex = new AtomicLong(lastTransactionIndexForNonRatis);
        if (this.isRatisEnabled) {
            this.ozoneManagerDoubleBuffer = null;
            this.handler = new OzoneManagerRequestHandler(impl, null);
        } else {
            this.ozoneManagerDoubleBuffer = new OzoneManagerDoubleBuffer.Builder().setOmMetadataManager(this.ozoneManager.getMetadataManager()).setOzoneManagerRatisSnapShot(i -> {}).enableRatis(this.isRatisEnabled).enableTracing(TracingUtil.isTracingEnabled((ConfigurationSource)this.ozoneManager.getConfiguration())).build();
            this.handler = new OzoneManagerRequestHandler(impl, this.ozoneManagerDoubleBuffer);
        }
        this.omRatisServer = ratisServer;
        this.dispatcher = new OzoneProtocolMessageDispatcher("OzoneProtocol", metrics, LOG, OMPBHelper::processForDebug, OMPBHelper::processForDebug);
        this.requestValidations = new RequestValidations().fromPackage(OM_REQUESTS_PACKAGE).withinContext(ValidationContext.of((LayoutVersionManager)this.ozoneManager.getVersionManager(), this.ozoneManager.getMetadataManager())).load();
    }

    public OzoneManagerProtocolProtos.OMResponse submitRequest(RpcController controller, OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.OMRequest validatedRequest;
        try {
            validatedRequest = (OzoneManagerProtocolProtos.OMRequest)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getValidateRequestLatencyNs(), () -> this.requestValidations.validateRequest(request));
        }
        catch (Exception e) {
            if (e instanceof OMException) {
                return this.createErrorResponse(request, (IOException)((OMException)e));
            }
            throw new ServiceException((Throwable)e);
        }
        OzoneManagerProtocolProtos.OMResponse response = (OzoneManagerProtocolProtos.OMResponse)this.dispatcher.processRequest((Object)validatedRequest, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
        return (OzoneManagerProtocolProtos.OMResponse)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getValidateResponseLatencyNs(), () -> this.requestValidations.validateResponse(request, response));
    }

    @VisibleForTesting
    public OzoneManagerProtocolProtos.OMResponse processRequest(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.OMResponse response = this.internalProcessRequest(request);
        if (response.hasOmLockDetails()) {
            OzoneManagerProtocolProtos.OMLockDetailsProto omLockDetailsProto = response.getOmLockDetails();
            Server.Call call = (Server.Call)Server.getCurCall().get();
            if (call != null) {
                call.getProcessingDetails().add(ProcessingDetails.Timing.LOCKWAIT, omLockDetailsProto.getWaitLockNanos(), TimeUnit.NANOSECONDS);
                call.getProcessingDetails().add(ProcessingDetails.Timing.LOCKSHARED, omLockDetailsProto.getReadLockNanos(), TimeUnit.NANOSECONDS);
                call.getProcessingDetails().add(ProcessingDetails.Timing.LOCKEXCLUSIVE, omLockDetailsProto.getWriteLockNanos(), TimeUnit.NANOSECONDS);
            }
        }
        return response;
    }

    private OzoneManagerProtocolProtos.OMResponse internalProcessRequest(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OMClientRequest omClientRequest = null;
        boolean s3Auth = false;
        try {
            OzoneManagerProtocolProtos.OMRequest requestToSubmit;
            if (request.hasS3Authentication()) {
                OzoneManager.setS3Auth(request.getS3Authentication());
                try {
                    s3Auth = true;
                    S3SecurityUtil.validateS3Credential(request, this.ozoneManager);
                }
                catch (IOException ex) {
                    OzoneManagerProtocolProtos.OMResponse oMResponse = this.createErrorResponse(request, ex);
                    OzoneManager.setS3Auth(null);
                    return oMResponse;
                }
            }
            if (!this.isRatisEnabled) {
                OzoneManagerProtocolProtos.OMResponse oMResponse = this.submitRequestDirectlyToOM(request);
                return oMResponse;
            }
            if (OmUtils.isReadOnly((OzoneManagerProtocolProtos.OMRequest)request)) {
                OzoneManagerProtocolProtos.OMResponse oMResponse = this.submitReadRequestToOM(request);
                return oMResponse;
            }
            if (!s3Auth) {
                OzoneManagerRatisUtils.checkLeaderStatus(this.ozoneManager);
            }
            try {
                omClientRequest = OzoneManagerRatisUtils.createClientRequest(request, this.ozoneManager);
                assert (omClientRequest != null);
                OMClientRequest finalOmClientRequest = omClientRequest;
                this.lastRequestToSubmit = requestToSubmit = this.preExecute(finalOmClientRequest);
            }
            catch (IOException ex) {
                if (omClientRequest != null) {
                    omClientRequest.handleRequestFailure(this.ozoneManager);
                }
                OzoneManagerProtocolProtos.OMResponse oMResponse = this.createErrorResponse(request, ex);
                OzoneManager.setS3Auth(null);
                return oMResponse;
            }
            OzoneManagerProtocolProtos.OMResponse response = this.submitRequestToRatis(requestToSubmit);
            if (!response.getSuccess()) {
                omClientRequest.handleRequestFailure(this.ozoneManager);
            }
            OzoneManagerProtocolProtos.OMResponse oMResponse = response;
            return oMResponse;
        }
        finally {
            OzoneManager.setS3Auth(null);
        }
    }

    private OzoneManagerProtocolProtos.OMRequest preExecute(OMClientRequest finalOmClientRequest) throws IOException {
        return (OzoneManagerProtocolProtos.OMRequest)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getPreExecuteLatencyNs(), () -> finalOmClientRequest.preExecute(this.ozoneManager));
    }

    @VisibleForTesting
    public OzoneManagerProtocolProtos.OMRequest getLastRequestToSubmit() {
        return this.lastRequestToSubmit;
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequestToRatis(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        return this.omRatisServer.submitRequest(request);
    }

    private OzoneManagerProtocolProtos.OMResponse submitReadRequestToOM(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OzoneManagerRatisServer.RaftServerStatus raftServerStatus = this.omRatisServer.checkLeaderStatus();
        if (raftServerStatus == OzoneManagerRatisServer.RaftServerStatus.LEADER_AND_READY || request.getCmdType().equals((Object)OzoneManagerProtocolProtos.Type.PrepareStatus)) {
            return this.handler.handleReadRequest(request);
        }
        throw this.createLeaderErrorException(raftServerStatus);
    }

    private ServiceException createLeaderErrorException(OzoneManagerRatisServer.RaftServerStatus raftServerStatus) {
        if (raftServerStatus == OzoneManagerRatisServer.RaftServerStatus.NOT_LEADER) {
            return this.createNotLeaderException();
        }
        return this.createLeaderNotReadyException();
    }

    private ServiceException createNotLeaderException() {
        RaftPeerId raftPeerId = this.omRatisServer.getRaftPeerId();
        RaftPeerId raftLeaderId = null;
        String raftLeaderAddress = null;
        RaftPeer leader = this.omRatisServer.getLeader();
        if (leader != null) {
            raftLeaderId = leader.getId();
            raftLeaderAddress = this.omRatisServer.getRaftLeaderAddress(leader);
        }
        OMNotLeaderException notLeaderException = raftLeaderId == null ? new OMNotLeaderException(raftPeerId) : new OMNotLeaderException(raftPeerId, raftLeaderId, raftLeaderAddress);
        LOG.debug(notLeaderException.getMessage());
        return new ServiceException((Throwable)notLeaderException);
    }

    private ServiceException createLeaderNotReadyException() {
        RaftPeerId raftPeerId = this.omRatisServer.getRaftPeerId();
        OMLeaderNotReadyException leaderNotReadyException = new OMLeaderNotReadyException(String.valueOf(raftPeerId.toString()) + " is Leader " + "but not ready to process request yet.");
        LOG.debug(leaderNotReadyException.getMessage());
        return new ServiceException((Throwable)leaderNotReadyException);
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequestDirectlyToOM(OzoneManagerProtocolProtos.OMRequest request) {
        OMClientResponse omClientResponse;
        try {
            if (OmUtils.isReadOnly((OzoneManagerProtocolProtos.OMRequest)request)) {
                return this.handler.handleReadRequest(request);
            }
            OMClientRequest omClientRequest = OzoneManagerRatisUtils.createClientRequest(request, this.ozoneManager);
            request = omClientRequest.preExecute(this.ozoneManager);
            long index = this.transactionIndex.incrementAndGet();
            omClientResponse = this.handler.handleWriteRequest(request, index);
        }
        catch (IOException ex) {
            return this.createErrorResponse(request, ex);
        }
        try {
            if (this.shouldFlushCache) {
                omClientResponse.getFlushFuture().get();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Future for {} is completed", (Object)request);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            String errorMessage = "Got error during waiting for flush to be completed for request" + request.toString();
            ExitUtils.terminate((int)1, (String)errorMessage, (Throwable)ex, (Logger)LOG);
            Thread.currentThread().interrupt();
        }
        return omClientResponse.getOMResponse();
    }

    private OzoneManagerProtocolProtos.OMResponse createErrorResponse(OzoneManagerProtocolProtos.OMRequest omRequest, IOException exception) {
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setStatus(OzoneManagerRatisUtils.exceptionToResponseStatus(exception)).setCmdType(omRequest.getCmdType()).setTraceID(omRequest.getTraceID()).setSuccess(false);
        if (exception.getMessage() != null) {
            omResponse.setMessage(exception.getMessage());
        }
        return omResponse.build();
    }

    public void stop() {
        if (!this.isRatisEnabled) {
            this.ozoneManagerDoubleBuffer.stop();
        }
    }

    public static Logger getLog() {
        return LOG;
    }

    public void awaitDoubleBufferFlush() throws InterruptedException {
        this.ozoneManagerDoubleBuffer.awaitFlush();
    }

    @VisibleForTesting
    public OzoneManagerDoubleBuffer getOzoneManagerDoubleBuffer() {
        return this.ozoneManagerDoubleBuffer;
    }

    @VisibleForTesting
    public void setShouldFlushCache(boolean shouldFlushCache) {
        this.shouldFlushCache = shouldFlushCache;
    }
}

