/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import java.net.InetSocketAddress;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMProxyInfo {
    private String serviceId;
    private String nodeId;
    private String rpcAddrStr;
    private InetSocketAddress rpcAddr;
    private Text dtService;
    private static final Logger LOG = LoggerFactory.getLogger(OMProxyInfo.class);

    OMProxyInfo(String serviceID, String nodeID, String rpcAddress) {
        this.serviceId = serviceID;
        this.nodeId = nodeID;
        this.rpcAddrStr = rpcAddress;
        this.rpcAddr = NetUtils.createSocketAddr((String)this.rpcAddrStr);
        if (this.rpcAddr.isUnresolved()) {
            LOG.warn("OzoneManager address {} for serviceID {} remains unresolved for node ID {} Check your ozone-site.xml file to ensure ozone manager addresses are configured properly.", new Object[]{rpcAddress, this.serviceId, this.nodeId});
            this.dtService = null;
        } else {
            this.dtService = SecurityUtil.buildTokenService((InetSocketAddress)this.rpcAddr);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("nodeId=").append(this.nodeId).append(",nodeAddress=").append(this.rpcAddrStr);
        return sb.toString();
    }

    public InetSocketAddress getAddress() {
        return this.rpcAddr;
    }

    public Text getDelegationTokenService() {
        return this.dtService;
    }
}

