/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.NodeDetails;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;

public final class OMConfiguration {
    private List<OMNodeDetails> omNodesInMemory = new ArrayList<OMNodeDetails>();
    private List<OMNodeDetails> omNodesInNewConf = new ArrayList<OMNodeDetails>();

    private OMConfiguration(List<OMNodeDetails> inMemoryNodeList, List<OMNodeDetails> onDiskNodeList) {
        this.omNodesInMemory.addAll(inMemoryNodeList);
        this.omNodesInNewConf.addAll(onDiskNodeList);
    }

    public List<String> getCurrentPeerList() {
        return this.omNodesInMemory.stream().map(NodeDetails::getNodeId).collect(Collectors.toList());
    }

    public Map<String, OMNodeDetails> getActiveOmNodesInNewConf() {
        return this.omNodesInNewConf.stream().filter(omNodeDetails -> !omNodeDetails.isDecommissioned()).collect(Collectors.toMap(NodeDetails::getNodeId, omNodeDetails -> omNodeDetails, (nodeId, omNodeDetails) -> omNodeDetails));
    }

    public Map<String, OMNodeDetails> getDecommissionedNodesInNewConf() {
        return this.omNodesInNewConf.stream().filter(omNodeDetails -> omNodeDetails.isDecommissioned()).collect(Collectors.toMap(NodeDetails::getNodeId, omNodeDetails -> omNodeDetails, (nodeId, omNodeDetails) -> omNodeDetails));
    }

    public static class Builder {
        private List<OMNodeDetails> omNodesInMemory = new ArrayList<OMNodeDetails>();
        private List<OMNodeDetails> omNodesInNewConf = new ArrayList<OMNodeDetails>();

        public Builder addToNodesInMemory(OMNodeDetails nodeDetails) {
            this.omNodesInMemory.add(nodeDetails);
            return this;
        }

        public Builder addToNodesInNewConf(OMNodeDetails nodeDetails) {
            this.omNodesInNewConf.add(nodeDetails);
            return this;
        }

        public OMConfiguration build() {
            return new OMConfiguration(this.omNodesInMemory, this.omNodesInNewConf);
        }
    }
}

