/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api.database;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.database.DatabaseRoleOptions;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.response.DatabaseResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class Database {
    private final VaultConfig config;
    private final String mountPath;
    private String nameSpace;

    public Database withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public Database(VaultConfig config) {
        this(config, "database");
    }

    public Database(VaultConfig config, String mountPath) {
        this.config = config;
        this.mountPath = mountPath;
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public DatabaseResponse createOrUpdateRole(String roleName, DatabaseRoleOptions options) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String requestJson = this.roleOptionsToJson(options);
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 204) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new DatabaseResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public DatabaseResponse getRole(String roleName) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new DatabaseResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public DatabaseResponse revoke(String serialNumber) throws VaultException {
        int retryCount = 0;
        while (true) {
            JsonObject jsonObject = new JsonObject();
            if (serialNumber != null) {
                jsonObject.add("serial_number", serialNumber);
            }
            String requestJson = jsonObject.toString();
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/revoke", this.config.getAddress(), this.mountPath)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).body(requestJson.getBytes(StandardCharsets.UTF_8)).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new DatabaseResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public DatabaseResponse deleteRole(String roleName) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).delete();
                if (restResponse.getStatus() != 204) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new DatabaseResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public DatabaseResponse creds(String roleName) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/creds/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                    String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
                }
                return new DatabaseResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    private String roleOptionsToJson(DatabaseRoleOptions options) {
        JsonObject jsonObject = Json.object();
        if (options != null) {
            this.addJsonFieldIfNotNull(jsonObject, "db_name", options.getDbName());
            this.addJsonFieldIfNotNull(jsonObject, "default_ttl", options.getDefaultTtl());
            this.addJsonFieldIfNotNull(jsonObject, "max_ttl", options.getMaxTtl());
            this.addJsonFieldIfNotNull(jsonObject, "creation_statements", this.joinList(options.getCreationStatements()));
            this.addJsonFieldIfNotNull(jsonObject, "revocation_statements", this.joinList(options.getRevocationStatements()));
            this.addJsonFieldIfNotNull(jsonObject, "rollback_statements", this.joinList(options.getRollbackStatements()));
            this.addJsonFieldIfNotNull(jsonObject, "renew_statements", this.joinList(options.getRenewStatements()));
        }
        return jsonObject.toString();
    }

    private String joinList(List<String> data) {
        String result = "";
        if (data != null && !data.isEmpty()) {
            result = String.join((CharSequence)",", data);
        }
        return result;
    }

    private JsonObject addJsonFieldIfNotNull(JsonObject jsonObject, String name, Object value) {
        if (value == null) {
            return jsonObject;
        }
        if (value instanceof String) {
            jsonObject.add(name, (String)value);
        } else if (value instanceof Boolean) {
            jsonObject.add(name, (Boolean)value);
        } else if (value instanceof Long) {
            jsonObject.add(name, (Long)value);
        }
        return jsonObject;
    }
}

