/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsCreateModes;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.util.StringUtils;
import org.apache.ozone.fs.http.HttpFSConstants;
import org.apache.ozone.fs.http.server.HttpFSServerWebApp;
import org.apache.ozone.fs.http.server.JsonUtil;
import org.apache.ozone.lib.service.FileSystemAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
public final class FSOperations {
    private static int bufferSize = 4096;
    private static final String HTTPFS_BUFFER_SIZE_KEY = "httpfs.buffer.size";
    private static final int HTTP_BUFFER_SIZE_DEFAULT = 4096;

    private FSOperations() {
    }

    public static void setBufferSize(Configuration conf) {
        bufferSize = conf.getInt(HTTPFS_BUFFER_SIZE_KEY, 4096);
    }

    private static Map<String, Object> toJson(FileStatus fileStatus) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("FileStatus", FSOperations.toJsonInner(fileStatus, true));
        return json;
    }

    private static Map<String, Object> toJson(FileStatus[] fileStatuses, boolean isFile) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, JSONArray> inner = new LinkedHashMap<String, JSONArray>();
        JSONArray statuses = new JSONArray();
        for (FileStatus f : fileStatuses) {
            statuses.add(FSOperations.toJsonInner(f, isFile));
        }
        inner.put("FileStatus", statuses);
        json.put("FileStatuses", inner);
        return json;
    }

    private static Map<String, Object> toJsonInner(FileStatus fileStatus, boolean emptyPathSuffix) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("pathSuffix", emptyPathSuffix ? "" : fileStatus.getPath().getName());
        HttpFSConstants.FILETYPE fileType = HttpFSConstants.FILETYPE.getType(fileStatus);
        json.put("type", fileType.toString());
        if (fileType.equals((Object)HttpFSConstants.FILETYPE.SYMLINK)) {
            try {
                json.put("symlink", fileStatus.getSymlink().getName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        json.put("length", fileStatus.getLen());
        json.put("owner", fileStatus.getOwner());
        json.put("group", fileStatus.getGroup());
        json.put("permission", HttpFSConstants.permissionToString(fileStatus.getPermission()));
        json.put("accessTime", fileStatus.getAccessTime());
        json.put("modificationTime", fileStatus.getModificationTime());
        json.put("blockSize", fileStatus.getBlockSize());
        json.put("replication", fileStatus.getReplication());
        if (fileStatus instanceof HdfsFileStatus) {
            HdfsFileStatus hdfsFileStatus = (HdfsFileStatus)fileStatus;
            json.put("childrenNum", hdfsFileStatus.getChildrenNum());
            json.put("fileId", hdfsFileStatus.getFileId());
            json.put("storagePolicy", hdfsFileStatus.getStoragePolicy());
        }
        if (fileStatus.getPermission().getAclBit()) {
            json.put("aclBit", true);
        }
        if (fileStatus.getPermission().getEncryptedBit()) {
            json.put("encBit", true);
        }
        if (fileStatus.getPermission().getErasureCodedBit()) {
            json.put("ecBit", true);
        }
        if (fileStatus.isSnapshotEnabled()) {
            json.put("snapshotEnabled", true);
        }
        return json;
    }

    private static Map<String, Object> toJson(FileSystem.DirectoryEntries entries, boolean isFile) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> inner = new LinkedHashMap<String, Object>();
        Map<String, Object> fileStatuses = FSOperations.toJson(entries.getEntries(), isFile);
        inner.put("partialListing", fileStatuses);
        inner.put("remainingEntries", entries.hasMore() ? 1 : 0);
        json.put("DirectoryListing", inner);
        return json;
    }

    private static Map<String, Object> aclStatusToJSON(AclStatus aclStatus) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> inner = new LinkedHashMap<String, Object>();
        JSONArray entriesArray = new JSONArray();
        inner.put("owner", aclStatus.getOwner());
        inner.put("group", aclStatus.getGroup());
        inner.put("permission", HttpFSConstants.permissionToString(aclStatus.getPermission()));
        inner.put("stickyBit", aclStatus.isStickyBit());
        for (AclEntry e : aclStatus.getEntries()) {
            entriesArray.add((Object)e.toString());
        }
        inner.put("entries", entriesArray);
        json.put("AclStatus", inner);
        return json;
    }

    private static Map fileChecksumToJSON(FileChecksum checksum) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("algorithm", checksum.getAlgorithmName());
        json.put("bytes", StringUtils.byteToHexString((byte[])checksum.getBytes()));
        json.put("length", checksum.getLength());
        LinkedHashMap<String, LinkedHashMap<String, Object>> response = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        response.put("FileChecksum", json);
        return response;
    }

    private static Map xAttrsToJSON(Map<String, byte[]> xAttrs, XAttrCodec encoding) throws IOException {
        LinkedHashMap<String, JSONArray> jsonMap = new LinkedHashMap<String, JSONArray>();
        JSONArray jsonArray = new JSONArray();
        if (xAttrs != null) {
            for (Map.Entry<String, byte[]> e : xAttrs.entrySet()) {
                LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
                json.put("name", e.getKey());
                if (e.getValue() != null) {
                    json.put("value", XAttrCodec.encodeValue((byte[])e.getValue(), (XAttrCodec)encoding));
                }
                jsonArray.add(json);
            }
        }
        jsonMap.put("XAttrs", jsonArray);
        return jsonMap;
    }

    private static Map xAttrNamesToJSON(List<String> names) throws IOException {
        LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>();
        jsonMap.put("XAttrNames", JSONArray.toJSONString(names));
        return jsonMap;
    }

    private static Map contentSummaryToJSON(ContentSummary contentSummary) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("directoryCount", contentSummary.getDirectoryCount());
        json.put("ecPolicy", contentSummary.getErasureCodingPolicy());
        json.put("fileCount", contentSummary.getFileCount());
        json.put("length", contentSummary.getLength());
        Map<String, Object> quotaUsageMap = FSOperations.quotaUsageToMap((QuotaUsage)contentSummary);
        for (Map.Entry<String, Object> e : quotaUsageMap.entrySet()) {
            if (e.getKey().equals("fileAndDirectoryCount")) continue;
            json.put(e.getKey(), e.getValue());
        }
        LinkedHashMap<String, LinkedHashMap<String, Object>> response = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        response.put("ContentSummary", json);
        return response;
    }

    private static Map quotaUsageToJSON(QuotaUsage quotaUsage) {
        LinkedHashMap<String, Map<String, Object>> response = new LinkedHashMap<String, Map<String, Object>>();
        Map<String, Object> quotaUsageMap = FSOperations.quotaUsageToMap(quotaUsage);
        response.put("QuotaUsage", quotaUsageMap);
        return response;
    }

    private static Map<String, Object> quotaUsageToMap(QuotaUsage quotaUsage) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("fileAndDirectoryCount", quotaUsage.getFileAndDirectoryCount());
        result.put("quota", quotaUsage.getQuota());
        result.put("spaceConsumed", quotaUsage.getSpaceConsumed());
        result.put("spaceQuota", quotaUsage.getSpaceQuota());
        TreeMap<String, TreeMap<String, Long>> typeQuota = new TreeMap<String, TreeMap<String, Long>>();
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            long tQuota = quotaUsage.getTypeQuota(t);
            if (tQuota == -1L) continue;
            TreeMap<String, Long> type = (TreeMap<String, Long>)typeQuota.get(t.toString());
            if (type == null) {
                type = new TreeMap<String, Long>();
                typeQuota.put(t.toString(), type);
            }
            type.put("quota", quotaUsage.getTypeQuota(t));
            type.put("consumed", quotaUsage.getTypeConsumed(t));
        }
        result.put("typeQuota", typeQuota);
        return result;
    }

    private static JSONObject toJSON(String name, Object value) {
        JSONObject json = new JSONObject();
        json.put((Object)name, value);
        return json;
    }

    private static JSONObject storagePolicyToJSON(BlockStoragePolicySpi policy) {
        BlockStoragePolicy p = (BlockStoragePolicy)policy;
        JSONObject policyJson = new JSONObject();
        policyJson.put((Object)"id", (Object)p.getId());
        policyJson.put((Object)"name", (Object)p.getName());
        policyJson.put((Object)"storageTypes", (Object)FSOperations.toJsonArray(p.getStorageTypes()));
        policyJson.put((Object)"creationFallbacks", (Object)FSOperations.toJsonArray(p.getCreationFallbacks()));
        policyJson.put((Object)"replicationFallbacks", (Object)FSOperations.toJsonArray(p.getReplicationFallbacks()));
        policyJson.put((Object)"copyOnCreateFile", (Object)p.isCopyOnCreateFile());
        return policyJson;
    }

    private static JSONArray toJsonArray(StorageType[] storageTypes) {
        JSONArray jsonArray = new JSONArray();
        for (StorageType type : storageTypes) {
            jsonArray.add((Object)type.toString());
        }
        return jsonArray;
    }

    private static JSONObject storagePoliciesToJSON(Collection<? extends BlockStoragePolicySpi> storagePolicies) {
        JSONObject json = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONObject policies = new JSONObject();
        if (storagePolicies != null) {
            for (BlockStoragePolicySpi blockStoragePolicySpi : storagePolicies) {
                JSONObject policyMap = FSOperations.storagePolicyToJSON(blockStoragePolicySpi);
                jsonArray.add((Object)policyMap);
            }
        }
        policies.put((Object)"BlockStoragePolicy", (Object)jsonArray);
        json.put((Object)"BlockStoragePolicies", (Object)policies);
        return json;
    }

    public static long copyBytes(InputStream in, OutputStream out) throws IOException {
        return FSOperations.copyBytes(in, out, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyBytes(InputStream in, OutputStream out, long count) throws IOException {
        long totalBytes = 0L;
        byte[] buf = new byte[bufferSize];
        long bytesRemaining = count;
        try {
            int bytesToRead;
            int bytesRead;
            while (bytesRemaining > 0L && (bytesRead = in.read(buf, 0, bytesToRead = (int)(bytesRemaining < (long)buf.length ? bytesRemaining : (long)buf.length))) != -1) {
                out.write(buf, 0, bytesRead);
                bytesRemaining -= (long)bytesRead;
                totalBytes += (long)bytesRead;
            }
            long l = totalBytes;
            return l;
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
    }

    @InterfaceAudience.Private
    public static class FSUnSetErasureCodingPolicy
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSUnSetErasureCodingPolicy(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("unsetErasureCodingPolicy is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            dfs.unsetErasureCodingPolicy(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSGetErasureCodingPolicy
    implements FileSystemAccess.FileSystemExecutor<String> {
        private Path path;

        public FSGetErasureCodingPolicy(String path) {
            this.path = new Path(path);
        }

        @Override
        public String execute(FileSystem fs) throws IOException {
            ErasureCodingPolicy policy = null;
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("getErasureCodingPolicy is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            policy = dfs.getErasureCodingPolicy(this.path);
            return JsonUtil.toJsonString(policy);
        }
    }

    @InterfaceAudience.Private
    public static class FSSetErasureCodingPolicy
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String policyName;

        public FSSetErasureCodingPolicy(String path, String policyName) {
            this.path = new Path(path);
            this.policyName = policyName;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("setErasureCodingPolicy is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            dfs.setErasureCodingPolicy(this.path, this.policyName);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSAccess
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private FsAction mode;

        public FSAccess(String path, FsAction mode) {
            this.path = new Path(path);
            this.mode = mode;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("checkaccess is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            dfs.access(this.path, this.mode);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrOpsCheckAccess();
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSGetServerDefaults
    implements FileSystemAccess.FileSystemExecutor<String> {
        @Override
        public String execute(FileSystem fs) throws IOException {
            FsServerDefaults sds = null;
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("getServerDefaults is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            sds = dfs.getServerDefaults();
            return JsonUtil.toJsonString(sds);
        }
    }

    @InterfaceAudience.Private
    public static class FSGetSnapshottableDirListing
    implements FileSystemAccess.FileSystemExecutor<String> {
        @Override
        public String execute(FileSystem fs) throws IOException {
            SnapshottableDirectoryStatus[] sds = null;
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("getSnapshottableDirListing is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            sds = dfs.getSnapshottableDirListing();
            return JsonUtil.toJsonString(sds);
        }
    }

    @InterfaceAudience.Private
    public static class FSGetSnapshotDiff
    implements FileSystemAccess.FileSystemExecutor<String> {
        private Path path;
        private String oldSnapshotName;
        private String snapshotName;

        public FSGetSnapshotDiff(String path, String oldSnapshotName, String snapshotName) {
            this.path = new Path(path);
            this.oldSnapshotName = oldSnapshotName;
            this.snapshotName = snapshotName;
        }

        @Override
        public String execute(FileSystem fs) throws IOException {
            SnapshotDiffReport sdr = null;
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("getSnapshotDiff is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            sdr = dfs.getSnapshotDiffReport(this.path, this.oldSnapshotName, this.snapshotName);
            if (sdr != null) {
                return JsonUtil.toJsonString(sdr);
            }
            return "";
        }
    }

    @InterfaceAudience.Private
    public static class FSRenameSnapshot
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String oldSnapshotName;
        private String snapshotName;

        public FSRenameSnapshot(String path, String oldSnapshotName, String snapshotName) {
            this.path = new Path(path);
            this.oldSnapshotName = oldSnapshotName;
            this.snapshotName = snapshotName;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.renameSnapshot(this.path, this.oldSnapshotName, this.snapshotName);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSDeleteSnapshot
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String snapshotName;

        public FSDeleteSnapshot(String path, String snapshotName) {
            this.path = new Path(path);
            this.snapshotName = snapshotName;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.deleteSnapshot(this.path, this.snapshotName);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSCreateSnapshot
    implements FileSystemAccess.FileSystemExecutor<String> {
        private Path path;
        private String snapshotName;

        public FSCreateSnapshot(String path, String snapshotName) {
            this.path = new Path(path);
            this.snapshotName = snapshotName;
        }

        @Override
        public String execute(FileSystem fs) throws IOException {
            Path snapshotPath = fs.createSnapshot(this.path, this.snapshotName);
            JSONObject json = FSOperations.toJSON("Path", snapshotPath.toString());
            return json.toJSONString().replaceAll("\\\\", "");
        }
    }

    @InterfaceAudience.Private
    public static class FSDisallowSnapshot
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSDisallowSnapshot(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("disallowSnapshot is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            dfs.disallowSnapshot(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSAllowSnapshot
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSAllowSnapshot(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedOperationException("allowSnapshot is not supported for HttpFs on " + fs.getClass() + ". Please check your fs.defaultFS configuration");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            dfs.allowSnapshot(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSUnsetStoragePolicy
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSUnsetStoragePolicy(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.unsetStoragePolicy(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetStoragePolicy
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String policyName;

        public FSSetStoragePolicy(String path, String policyName) {
            this.path = new Path(path);
            this.policyName = policyName;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setStoragePolicy(this.path, this.policyName);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSGetStoragePolicy
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;

        public FSGetStoragePolicy(String path) {
            this.path = new Path(path);
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            BlockStoragePolicySpi storagePolicy = fs.getStoragePolicy(this.path);
            JSONObject json = new JSONObject();
            json.put((Object)"BlockStoragePolicy", (Object)FSOperations.storagePolicyToJSON(storagePolicy));
            return json;
        }
    }

    @InterfaceAudience.Private
    public static class FSGetAllStoragePolicies
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            Collection storagePolicies = fs.getAllStoragePolicies();
            return FSOperations.storagePoliciesToJSON(storagePolicies);
        }
    }

    @InterfaceAudience.Private
    public static class FSGetXAttrs
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;
        private List<String> names;
        private XAttrCodec encoding;

        public FSGetXAttrs(String path, List<String> names, XAttrCodec encoding) {
            this.path = new Path(path);
            this.names = names;
            this.encoding = encoding;
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            Map xattrs = null;
            xattrs = this.names != null && !this.names.isEmpty() ? fs.getXAttrs(this.path, this.names) : fs.getXAttrs(this.path);
            return FSOperations.xAttrsToJSON(xattrs, this.encoding);
        }
    }

    @InterfaceAudience.Private
    public static class FSListXAttrs
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSListXAttrs(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            List names = fs.listXAttrs(this.path);
            return FSOperations.xAttrNamesToJSON(names);
        }
    }

    @InterfaceAudience.Private
    public static class FSRemoveXAttr
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String name;

        public FSRemoveXAttr(String path, String name) {
            this.path = new Path(path);
            this.name = name;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.removeXAttr(this.path, this.name);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetXAttr
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String name;
        private byte[] value;
        private EnumSet<XAttrSetFlag> flag;

        public FSSetXAttr(String path, String name, String encodedValue, EnumSet<XAttrSetFlag> flag) throws IOException {
            this.path = new Path(path);
            this.name = name;
            this.value = XAttrCodec.decodeValue((String)encodedValue);
            this.flag = flag;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setXAttr(this.path, this.name, this.value, this.flag);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetTimes
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private long mTime;
        private long aTime;

        public FSSetTimes(String path, long mTime, long aTime) {
            this.path = new Path(path);
            this.mTime = mTime;
            this.aTime = aTime;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setTimes(this.path, this.mTime, this.aTime);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetReplication
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private short replication;

        public FSSetReplication(String path, short replication) {
            this.path = new Path(path);
            this.replication = replication;
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            boolean ret = fs.setReplication(this.path, this.replication);
            JSONObject json = new JSONObject();
            json.put((Object)"boolean", (Object)ret);
            return json;
        }
    }

    @InterfaceAudience.Private
    public static class FSAclStatus
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSAclStatus(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            AclStatus status = fs.getAclStatus(this.path);
            return FSOperations.aclStatusToJSON(status);
        }
    }

    @InterfaceAudience.Private
    public static class FSTrashRoot
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;

        public FSTrashRoot(String path) {
            this.path = new Path(path);
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            Path trashRoot = fs.getTrashRoot(this.path);
            JSONObject json = new JSONObject();
            json.put((Object)"Path", (Object)trashRoot.toUri().getPath());
            return json;
        }
    }

    @InterfaceAudience.Private
    public static class FSRemoveDefaultAcl
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSRemoveDefaultAcl(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.removeDefaultAcl(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSRemoveAclEntries
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private List<AclEntry> aclEntries;

        public FSRemoveAclEntries(String path, String aclSpec) {
            this.path = new Path(path);
            this.aclEntries = AclEntry.parseAclSpec((String)aclSpec, (boolean)false);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.removeAclEntries(this.path, this.aclEntries);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSModifyAclEntries
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private List<AclEntry> aclEntries;

        public FSModifyAclEntries(String path, String aclSpec) {
            this.path = new Path(path);
            this.aclEntries = AclEntry.parseAclSpec((String)aclSpec, (boolean)true);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.modifyAclEntries(this.path, this.aclEntries);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSRemoveAcl
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSRemoveAcl(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.removeAcl(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetAcl
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private List<AclEntry> aclEntries;

        public FSSetAcl(String path, String aclSpec) {
            this.path = new Path(path);
            this.aclEntries = AclEntry.parseAclSpec((String)aclSpec, (boolean)true);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setAcl(this.path, this.aclEntries);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetPermission
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private short permission;

        public FSSetPermission(String path, short permission) {
            this.path = new Path(path);
            this.permission = permission;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            FsPermission fsPermission = new FsPermission(this.permission);
            fs.setPermission(this.path, fsPermission);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetOwner
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String owner;
        private String group;

        public FSSetOwner(String path, String owner, String group) {
            this.path = new Path(path);
            this.owner = owner;
            this.group = group;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setOwner(this.path, this.owner, this.group);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSRename
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private Path toPath;

        public FSRename(String path, String toPath) {
            this.path = new Path(path);
            this.toPath = new Path(toPath);
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            boolean renamed = fs.rename(this.path, this.toPath);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrOpsRename();
            return FSOperations.toJSON("boolean", renamed);
        }
    }

    @InterfaceAudience.Private
    public static class FSOpen
    implements FileSystemAccess.FileSystemExecutor<InputStream> {
        private Path path;

        public FSOpen(String path) {
            this.path = new Path(path);
        }

        @Override
        public InputStream execute(FileSystem fs) throws IOException {
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrOpsOpen();
            return fs.open(this.path, bufferSize);
        }
    }

    @InterfaceAudience.Private
    public static class FSMkdirs
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private short permission;
        private short unmaskedPermission;

        public FSMkdirs(String path, short permission, short unmaskedPermission) {
            this.path = new Path(path);
            this.permission = permission;
            this.unmaskedPermission = unmaskedPermission;
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            FsPermission fsPermission = new FsPermission(this.permission);
            if (this.unmaskedPermission != -1) {
                fsPermission = FsCreateModes.create((FsPermission)fsPermission, (FsPermission)new FsPermission(this.unmaskedPermission));
            }
            boolean mkdirs = fs.mkdirs(this.path, fsPermission);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrOpsMkdir();
            return FSOperations.toJSON("boolean", mkdirs);
        }
    }

    @InterfaceAudience.Private
    public static class FSListStatusBatch
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private final Path path;
        private final byte[] token;

        public FSListStatusBatch(String path, byte[] token) throws IOException {
            this.path = new Path(path);
            this.token = (byte[])token.clone();
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            WrappedFileSystem wrappedFS = new WrappedFileSystem(fs);
            FileSystem.DirectoryEntries entries = wrappedFS.listStatusBatch(this.path, this.token);
            return FSOperations.toJson(entries, wrappedFS.getFileStatus(this.path).isFile());
        }

        private static class WrappedFileSystem
        extends FilterFileSystem {
            WrappedFileSystem(FileSystem f) {
                super(f);
            }

            public FileSystem.DirectoryEntries listStatusBatch(Path f, byte[] token) throws FileNotFoundException, IOException {
                return super.listStatusBatch(f, token);
            }
        }
    }

    @InterfaceAudience.Private
    public static class FSListStatus
    implements FileSystemAccess.FileSystemExecutor<Map>,
    PathFilter {
        private Path path;
        private PathFilter filter;

        public FSListStatus(String path, String filter) throws IOException {
            this.path = new Path(path);
            this.filter = filter == null ? this : new GlobFilter(filter);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            FileStatus[] fileStatuses = fs.listStatus(this.path, this.filter);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrOpsListing();
            return FSOperations.toJson(fileStatuses, fs.getFileStatus(this.path).isFile());
        }

        public boolean accept(Path p) {
            return true;
        }
    }

    @InterfaceAudience.Private
    public static class FSHomeDir
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            Path homeDir = fs.getHomeDirectory();
            JSONObject json = new JSONObject();
            json.put((Object)"Path", (Object)homeDir.toUri().getPath());
            return json;
        }
    }

    @InterfaceAudience.Private
    public static class FSFileStatus
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSFileStatus(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            FileStatus status = fs.getFileStatus(this.path);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrOpsStat();
            return FSOperations.toJson(status);
        }
    }

    @InterfaceAudience.Private
    public static class FSFileChecksum
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSFileChecksum(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            FileChecksum checksum = fs.getFileChecksum(this.path);
            return FSOperations.fileChecksumToJSON(checksum);
        }
    }

    @InterfaceAudience.Private
    public static class FSDelete
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private boolean recursive;

        public FSDelete(String path, boolean recursive) {
            this.path = new Path(path);
            this.recursive = recursive;
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            boolean deleted = fs.delete(this.path, this.recursive);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrOpsDelete();
            return FSOperations.toJSON(StringUtils.toLowerCase((String)"boolean"), deleted);
        }
    }

    @InterfaceAudience.Private
    public static class FSCreate
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private InputStream is;
        private Path path;
        private short permission;
        private short unmaskedPermission;
        private boolean override;
        private short replication;
        private long blockSize;

        public FSCreate(InputStream is, String path, short perm, boolean override, short repl, long blockSize, short unmaskedPerm) {
            this.is = is;
            this.path = new Path(path);
            this.permission = perm;
            this.unmaskedPermission = unmaskedPerm;
            this.override = override;
            this.replication = repl;
            this.blockSize = blockSize;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            if (this.replication == -1) {
                this.replication = fs.getDefaultReplication(this.path);
            }
            if (this.blockSize == -1L) {
                this.blockSize = fs.getDefaultBlockSize(this.path);
            }
            FsPermission fsPermission = new FsPermission(this.permission);
            if (this.unmaskedPermission != -1) {
                fsPermission = FsCreateModes.create((FsPermission)fsPermission, (FsPermission)new FsPermission(this.unmaskedPermission));
            }
            FSDataOutputStream os = fs.create(this.path, fsPermission, this.override, bufferSize, this.replication, this.blockSize, null);
            long bytes = FSOperations.copyBytes(this.is, (OutputStream)os);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrBytesWritten(bytes);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSQuotaUsage
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSQuotaUsage(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            QuotaUsage quotaUsage = fs.getQuotaUsage(this.path);
            return FSOperations.quotaUsageToJSON(quotaUsage);
        }
    }

    @InterfaceAudience.Private
    public static class FSContentSummary
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSContentSummary(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            ContentSummary contentSummary = fs.getContentSummary(this.path);
            return FSOperations.contentSummaryToJSON(contentSummary);
        }
    }

    @InterfaceAudience.Private
    public static class FSTruncate
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private long newLength;

        public FSTruncate(String path, long newLength) {
            this.path = new Path(path);
            this.newLength = newLength;
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            boolean result = fs.truncate(this.path, this.newLength);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrOpsTruncate();
            return FSOperations.toJSON(StringUtils.toLowerCase((String)"boolean"), result);
        }
    }

    @InterfaceAudience.Private
    public static class FSConcat
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private Path[] sources;

        public FSConcat(String path, String[] sources) {
            this.sources = new Path[sources.length];
            for (int i = 0; i < sources.length; ++i) {
                this.sources[i] = new Path(sources[i]);
            }
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.concat(this.path, this.sources);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSAppend
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private InputStream is;
        private Path path;

        public FSAppend(InputStream is, String path) {
            this.is = is;
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            FSDataOutputStream os = fs.append(this.path, bufferSize);
            long bytes = FSOperations.copyBytes(this.is, (OutputStream)os);
            HttpFSServerWebApp.get();
            HttpFSServerWebApp.getMetrics().incrBytesWritten(bytes);
            return null;
        }
    }
}

