/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.proto.ReconfigureProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolPB;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HddsDatanodeClientProtocolServer
extends ServiceRuntimeInfoImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HddsDatanodeClientProtocolServer.class);
    private final RPC.Server rpcServer;
    private final InetSocketAddress clientRpcAddress;
    private final OzoneConfiguration conf;

    protected HddsDatanodeClientProtocolServer(DatanodeDetails datanodeDetails, OzoneConfiguration conf, VersionInfo versionInfo, ReconfigurationHandler reconfigurationHandler) throws IOException {
        super(versionInfo);
        this.conf = conf;
        this.rpcServer = this.getRpcServer(conf, reconfigurationHandler);
        this.clientRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)this.conf, (String)"hdds.datanode.client.address", (InetSocketAddress)HddsUtils.getDatanodeRpcAddress((ConfigurationSource)conf), (RPC.Server)this.rpcServer);
        datanodeDetails.setPort(DatanodeDetails.Port.Name.CLIENT_RPC, this.clientRpcAddress.getPort());
    }

    public void start() {
        LOG.info("RPC server for Client " + this.getClientRpcAddress());
        this.rpcServer.start();
    }

    public void stop() {
        try {
            LOG.info("Stopping the RPC server for Client Protocol");
            this.getClientRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Client Protocol RPC stop failed.", (Throwable)ex);
        }
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Client Protocol");
        this.getClientRpcServer().join();
    }

    private RPC.Server getRpcServer(OzoneConfiguration configuration, ReconfigurationHandler reconfigurationHandler) throws IOException {
        InetSocketAddress rpcAddress = HddsUtils.getDatanodeRpcAddress((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)configuration, ReconfigureProtocolPB.class, ProtobufRpcEngine.class);
        int handlerCount = this.conf.getInt("hdds.datanode.handler.count", 1);
        ReconfigureProtocolServerSideTranslatorPB reconfigureServerProtocol = new ReconfigureProtocolServerSideTranslatorPB((ReconfigureProtocol)reconfigurationHandler);
        BlockingService reconfigureService = ReconfigureProtocolProtos.ReconfigureProtocolService.newReflectiveBlockingService((ReconfigureProtocolProtos.ReconfigureProtocolService.BlockingInterface)reconfigureServerProtocol);
        return (RPC.Server)HddsUtils.preserveThreadName(() -> this.startRpcServer((Configuration)configuration, rpcAddress, ReconfigureProtocolPB.class, reconfigureService, handlerCount));
    }

    private RPC.Server startRpcServer(Configuration configuration, InetSocketAddress addr, Class<?> protocol, BlockingService instance, int handlerCount) throws IOException {
        return new RPC.Builder(configuration).setProtocol(protocol).setInstance((Object)instance).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(null).build();
    }

    private RPC.Server getClientRpcServer() {
        return this.rpcServer;
    }

    public InetSocketAddress getClientRpcAddress() {
        return this.clientRpcAddress;
    }
}

