/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.util.StringUtils;

public final class DeletedContainerBlocksSummary {
    private final List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> blocks;
    private final Map<Long, Integer> txSummary;
    private int numOfRetryTxs;
    private final Map<Long, Integer> blockSummary;
    private int numOfBlocks;

    private DeletedContainerBlocksSummary(List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> blocks) {
        this.blocks = blocks;
        this.txSummary = Maps.newHashMap();
        this.blockSummary = Maps.newHashMap();
        blocks.forEach(entry -> {
            this.txSummary.put(entry.getTxID(), entry.getCount());
            if (entry.getCount() > 0) {
                ++this.numOfRetryTxs;
            }
            if (this.blockSummary.containsKey(entry.getContainerID())) {
                this.blockSummary.put(entry.getContainerID(), this.blockSummary.get(entry.getContainerID()) + entry.getLocalIDCount());
            } else {
                this.blockSummary.put(entry.getContainerID(), entry.getLocalIDCount());
            }
            this.numOfBlocks += entry.getLocalIDCount();
        });
    }

    public static DeletedContainerBlocksSummary getFrom(List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> blocks) {
        return new DeletedContainerBlocksSummary(blocks);
    }

    public int getNumOfTxs() {
        return this.txSummary.size();
    }

    public int getNumOfBlocks() {
        return this.numOfBlocks;
    }

    public int getNumOfRetryTxs() {
        return this.numOfRetryTxs;
    }

    public int getNumOfContainers() {
        return this.blockSummary.size();
    }

    public String getTXIDs() {
        return String.join((CharSequence)",", this.txSummary.keySet().stream().map(String::valueOf).collect(Collectors.toList()));
    }

    public String getTxIDSummary() {
        List txSummaryEntry = this.txSummary.entrySet().stream().map(entry -> entry.getKey() + "(" + entry.getValue() + ")").collect(Collectors.toList());
        return "[" + String.join((CharSequence)",", txSummaryEntry) + "]";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction blks : this.blocks) {
            sb.append(" ").append("TXID=").append(blks.getTxID()).append(", ").append("TimesProceed=").append(blks.getCount()).append(", ").append(blks.getContainerID()).append(" : [").append(StringUtils.join((char)',', (Iterable)blks.getLocalIDList())).append("]").append("\n");
        }
        return sb.toString();
    }
}

