/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.interfaces;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.hdfs.util.RwLock;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerPacker;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;

public interface Container<CONTAINERDATA extends ContainerData>
extends RwLock {
    public void create(VolumeSet var1, VolumeChoosingPolicy var2, String var3) throws StorageContainerException;

    public void delete() throws StorageContainerException;

    public boolean hasBlocks() throws IOException;

    public void update(Map<String, String> var1, boolean var2) throws StorageContainerException;

    public void updateDataScanTimestamp(Instant var1) throws StorageContainerException;

    public CONTAINERDATA getContainerData();

    public ContainerProtos.ContainerDataProto.State getContainerState();

    public void markContainerForClose() throws StorageContainerException;

    public void markContainerUnhealthy() throws StorageContainerException;

    public void markContainerForDelete();

    public void quasiClose() throws StorageContainerException;

    public void close() throws StorageContainerException;

    public ContainerProtos.ContainerType getContainerType();

    public File getContainerFile();

    public void updateDeleteTransactionId(long var1);

    public void importContainerData(InputStream var1, ContainerPacker<CONTAINERDATA> var2) throws IOException;

    public void exportContainerData(OutputStream var1, ContainerPacker<CONTAINERDATA> var2) throws IOException;

    public StorageContainerDatanodeProtocolProtos.ContainerReplicaProto getContainerReport() throws StorageContainerException;

    public void updateBlockCommitSequenceId(long var1);

    public long getBlockCommitSequenceId();

    public boolean shouldScanMetadata();

    public ScanResult scanMetaData() throws InterruptedException;

    public boolean shouldScanData();

    public ScanResult scanData(DataTransferThrottler var1, Canceler var2) throws InterruptedException;

    public static class ScanResult {
        private final boolean healthy;
        private final File unhealthyFile;
        private final FailureType failureType;
        private final Throwable exception;

        private ScanResult(boolean healthy, FailureType failureType, File unhealthyFile, Throwable exception) {
            this.healthy = healthy;
            this.unhealthyFile = unhealthyFile;
            this.failureType = failureType;
            this.exception = exception;
        }

        public static ScanResult healthy() {
            return new ScanResult(true, null, null, null);
        }

        public static ScanResult unhealthy(FailureType type, File failingFile, Throwable exception) {
            return new ScanResult(false, type, failingFile, exception);
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public File getUnhealthyFile() {
            return this.unhealthyFile;
        }

        public FailureType getFailureType() {
            return this.failureType;
        }

        public Throwable getException() {
            return this.exception;
        }

        public static enum FailureType {
            MISSING_CONTAINER_DIR,
            MISSING_METADATA_DIR,
            MISSING_CONTAINER_FILE,
            MISSING_CHUNKS_DIR,
            MISSING_CHUNK_FILE,
            CORRUPT_CONTAINER_FILE,
            CORRUPT_CHUNK,
            INCONSISTENT_CHUNK_LENGTH,
            INACCESSIBLE_DB,
            WRITE_FAILURE;

        }
    }
}

