/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import com.google.common.base.CaseFormat;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.WordUtils;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(about="Datanode Queue Metrics", context="ozone")
public final class DatanodeQueueMetrics
implements MetricsSource {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeQueueMetrics.class);
    public static final String METRICS_SOURCE_NAME = DatanodeQueueMetrics.class.getSimpleName();
    public static final String STATE_CONTEXT_COMMAND_QUEUE_PREFIX = "StateContextCommandQueue";
    public static final String COMMAND_DISPATCHER_QUEUE_PREFIX = "CommandDispatcherCommandQueue";
    public static final String INCREMENTAL_REPORT_QUEUE_PREFIX = "IncrementalReportQueue";
    public static final String CONTAINER_ACTION_QUEUE_PREFIX = "ContainerActionQueue";
    public static final String PIPELINE_ACTION_QUEUE_PREFIX = "PipelineActionQueue";
    private MetricsRegistry registry = new MetricsRegistry(METRICS_SOURCE_NAME);
    private DatanodeStateMachine datanodeStateMachine;
    private static DatanodeQueueMetrics instance;
    private Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, MetricsInfo> stateContextCommandQueueMap;
    private Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, MetricsInfo> commandDispatcherQueueMap;
    private Map<InetSocketAddress, MetricsInfo> incrementalReportsQueueMap;
    private Map<InetSocketAddress, MetricsInfo> containerActionQueueMap;
    private Map<InetSocketAddress, MetricsInfo> pipelineActionQueueMap;

    public DatanodeQueueMetrics(DatanodeStateMachine datanodeStateMachine) {
        this.datanodeStateMachine = datanodeStateMachine;
        this.initializeQueues();
    }

    public static synchronized DatanodeQueueMetrics create(DatanodeStateMachine datanodeStateMachine) {
        if (instance != null) {
            return instance;
        }
        instance = (DatanodeQueueMetrics)DefaultMetricsSystem.instance().register(METRICS_SOURCE_NAME, "Queue metrics in Datanode", (Object)new DatanodeQueueMetrics(datanodeStateMachine));
        return instance;
    }

    private void initializeQueues() {
        this.stateContextCommandQueueMap = new HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, MetricsInfo>();
        for (StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type type : StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.values()) {
            this.stateContextCommandQueueMap.put(type, this.getMetricsInfo(STATE_CONTEXT_COMMAND_QUEUE_PREFIX, String.valueOf(type)));
        }
        this.commandDispatcherQueueMap = new HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, MetricsInfo>();
        for (StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type type : StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.values()) {
            this.commandDispatcherQueueMap.put(type, this.getMetricsInfo(COMMAND_DISPATCHER_QUEUE_PREFIX, String.valueOf(type)));
        }
        this.incrementalReportsQueueMap = new HashMap<InetSocketAddress, MetricsInfo>();
        this.containerActionQueueMap = new HashMap<InetSocketAddress, MetricsInfo>();
        this.pipelineActionQueueMap = new HashMap<InetSocketAddress, MetricsInfo>();
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder builder = collector.addRecord(METRICS_SOURCE_NAME);
        Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> tmpMap = this.datanodeStateMachine.getContext().getCommandQueueSummary();
        for (Map.Entry<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, MetricsInfo> entry : this.stateContextCommandQueueMap.entrySet()) {
            builder.addGauge(entry.getValue(), (long)tmpMap.getOrDefault(entry.getKey(), 0).intValue());
        }
        tmpMap = this.datanodeStateMachine.getCommandDispatcher().getQueuedCommandCount();
        for (Map.Entry<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, MetricsInfo> entry : this.commandDispatcherQueueMap.entrySet()) {
            builder.addGauge(entry.getValue(), (long)tmpMap.getOrDefault(entry.getKey(), 0).intValue());
        }
        for (Map.Entry<Object, MetricsInfo> entry : this.incrementalReportsQueueMap.entrySet()) {
            builder.addGauge(entry.getValue(), this.datanodeStateMachine.getContext().getIncrementalReportQueueSize().getOrDefault(entry.getKey(), 0).intValue());
        }
        for (Map.Entry<Object, MetricsInfo> entry : this.containerActionQueueMap.entrySet()) {
            builder.addGauge(entry.getValue(), this.datanodeStateMachine.getContext().getContainerActionQueueSize().getOrDefault(entry.getKey(), 0).intValue());
        }
        for (Map.Entry<Object, MetricsInfo> entry : this.pipelineActionQueueMap.entrySet()) {
            builder.addGauge(entry.getValue(), this.datanodeStateMachine.getContext().getPipelineActionQueueSize().getOrDefault(entry.getKey(), 0).intValue());
        }
    }

    public static synchronized void unRegister() {
        instance = null;
        DefaultMetricsSystem.instance().unregisterSource(METRICS_SOURCE_NAME);
    }

    public void addEndpoint(InetSocketAddress endpoint) {
        this.incrementalReportsQueueMap.computeIfAbsent(endpoint, k -> this.getMetricsInfo(INCREMENTAL_REPORT_QUEUE_PREFIX, CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, k.getHostName())));
        this.containerActionQueueMap.computeIfAbsent(endpoint, k -> this.getMetricsInfo(CONTAINER_ACTION_QUEUE_PREFIX, CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, k.getHostName())));
        this.pipelineActionQueueMap.computeIfAbsent(endpoint, k -> this.getMetricsInfo(PIPELINE_ACTION_QUEUE_PREFIX, CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, k.getHostName())));
    }

    private MetricsInfo getMetricsInfo(String prefix, String metricName) {
        String metric = prefix + WordUtils.capitalize((String)metricName) + "Size";
        String description = "Queue size of " + metricName + " from " + prefix;
        return Interns.info((String)metric, (String)description);
    }
}

