/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.datanode;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.states.DatanodeState;
import org.apache.hadoop.ozone.container.common.states.endpoint.HeartbeatEndpointTask;
import org.apache.hadoop.ozone.container.common.states.endpoint.RegisterEndpointTask;
import org.apache.hadoop.ozone.container.common.states.endpoint.VersionEndpointTask;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningDatanodeState
implements DatanodeState {
    static final Logger LOG = LoggerFactory.getLogger(RunningDatanodeState.class);
    private final SCMConnectionManager connectionManager;
    private final ConfigurationSource conf;
    private final StateContext context;
    private CompletionService<EndpointStateMachine.EndPointStates> ecs;
    private Map<EndpointStateMachine, Map<EndpointStateMachine.EndPointStates, Callable<EndpointStateMachine.EndPointStates>>> endpointTasks;

    public RunningDatanodeState(ConfigurationSource conf, SCMConnectionManager connectionManager, StateContext context) {
        this.connectionManager = connectionManager;
        this.conf = conf;
        this.context = context;
        this.initEndPointTask();
    }

    private void initEndPointTask() {
        this.endpointTasks = new HashMap<EndpointStateMachine, Map<EndpointStateMachine.EndPointStates, Callable<EndpointStateMachine.EndPointStates>>>();
        for (EndpointStateMachine endpoint : this.connectionManager.getValues()) {
            EnumMap<EndpointStateMachine.EndPointStates, VersionEndpointTask> endpointTaskForState = new EnumMap<EndpointStateMachine.EndPointStates, VersionEndpointTask>(EndpointStateMachine.EndPointStates.class);
            for (EndpointStateMachine.EndPointStates state : EndpointStateMachine.EndPointStates.values()) {
                Callable<EndpointStateMachine.EndPointStates> endPointTask = null;
                switch (state) {
                    case GETVERSION: {
                        endPointTask = new VersionEndpointTask(endpoint, this.conf, this.context.getParent().getContainer());
                        break;
                    }
                    case REGISTER: {
                        endPointTask = RegisterEndpointTask.newBuilder().setConfig(this.conf).setEndpointStateMachine(endpoint).setContext(this.context).setDatanodeDetails(this.context.getParent().getDatanodeDetails()).setOzoneContainer(this.context.getParent().getContainer()).build();
                        break;
                    }
                    case HEARTBEAT: {
                        endPointTask = HeartbeatEndpointTask.newBuilder().setConfig(this.conf).setEndpointStateMachine(endpoint).setDatanodeDetails(this.context.getParent().getDatanodeDetails()).setContext(this.context).build();
                        break;
                    }
                }
                if (endPointTask == null) continue;
                endpointTaskForState.put(state, (VersionEndpointTask)endPointTask);
            }
            this.endpointTasks.put(endpoint, endpointTaskForState);
        }
    }

    @Override
    public void onEnter() {
        LOG.trace("Entering handshake task.");
    }

    @Override
    public void onExit() {
        LOG.trace("Exiting handshake task.");
    }

    @Override
    public void execute(ExecutorService executor) {
        this.ecs = new ExecutorCompletionService<EndpointStateMachine.EndPointStates>(executor);
        for (EndpointStateMachine endpoint : this.connectionManager.getValues()) {
            Callable<EndpointStateMachine.EndPointStates> endpointTask = this.getEndPointTask(endpoint);
            if (endpointTask != null) {
                long heartbeatFrequency = endpoint.isPassive() ? this.context.getReconHeartbeatFrequency() : this.context.getHeartbeatFrequency();
                this.ecs.submit(() -> (EndpointStateMachine.EndPointStates)((Object)((Object)endpoint.getExecutorService().submit(endpointTask).get(heartbeatFrequency, TimeUnit.MILLISECONDS))));
                continue;
            }
            LOG.error("State is Shutdown in RunningDatanodeState");
            this.context.setState(DatanodeStateMachine.DatanodeStates.SHUTDOWN);
        }
    }

    @VisibleForTesting
    public void setExecutorCompletionService(ExecutorCompletionService e) {
        this.ecs = e;
    }

    private Callable<EndpointStateMachine.EndPointStates> getEndPointTask(EndpointStateMachine endpoint) {
        if (this.endpointTasks.containsKey(endpoint)) {
            return this.endpointTasks.get(endpoint).get((Object)endpoint.getState());
        }
        throw new IllegalArgumentException("Illegal endpoint: " + endpoint);
    }

    private DatanodeStateMachine.DatanodeStates computeNextContainerState(List<Future<EndpointStateMachine.EndPointStates>> results) {
        for (Future<EndpointStateMachine.EndPointStates> state : results) {
            try {
                if (state.get() != EndpointStateMachine.EndPointStates.SHUTDOWN) continue;
                return DatanodeStateMachine.DatanodeStates.SHUTDOWN;
            }
            catch (InterruptedException e) {
                LOG.error("Error in executing end point task.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.error("Error in executing end point task.", (Throwable)e);
            }
        }
        return DatanodeStateMachine.DatanodeStates.RUNNING;
    }

    public DatanodeStateMachine.DatanodeStates await(long duration, TimeUnit timeUnit) throws InterruptedException {
        long durationMS;
        int count = this.connectionManager.getValues().size();
        int returned = 0;
        long timeLeft = durationMS = timeUnit.toMillis(duration);
        long startTime = Time.monotonicNow();
        LinkedList<Future<EndpointStateMachine.EndPointStates>> results = new LinkedList<Future<EndpointStateMachine.EndPointStates>>();
        while (returned < count && timeLeft > 0L) {
            Future<EndpointStateMachine.EndPointStates> result = this.ecs.poll(timeLeft, TimeUnit.MILLISECONDS);
            if (result != null) {
                results.add(result);
                ++returned;
            }
            timeLeft = durationMS - (Time.monotonicNow() - startTime);
        }
        return this.computeNextContainerState(results);
    }
}

