/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ContainerLogger {
    @VisibleForTesting
    public static final String LOG_NAME = "ContainerLog";
    private static final Logger LOG = LogManager.getLogger((String)"ContainerLog");
    private static final String FIELD_SEPARATOR = " | ";

    private ContainerLogger() {
    }

    public static void logOpen(ContainerData containerData) {
        LOG.info(ContainerLogger.getMessage(containerData));
    }

    public static void logClosing(ContainerData containerData) {
        LOG.info(ContainerLogger.getMessage(containerData));
    }

    public static void logQuasiClosed(ContainerData containerData, String message) {
        LOG.warn(ContainerLogger.getMessage(containerData, message));
    }

    public static void logClosed(ContainerData containerData) {
        LOG.info(ContainerLogger.getMessage(containerData));
    }

    public static void logUnhealthy(ContainerData containerData, Container.ScanResult reason) {
        String message = (Object)((Object)reason.getFailureType()) + " for file " + reason.getUnhealthyFile() + ". Message: " + reason.getException().getMessage();
        LOG.error(ContainerLogger.getMessage(containerData, message));
    }

    public static void logLost(ContainerData containerData, String message) {
        LOG.error(ContainerLogger.getMessage(containerData, message));
    }

    public static void logDeleted(ContainerData containerData, boolean force) {
        if (force) {
            LOG.info(ContainerLogger.getMessage(containerData, "Container force deleted"));
        } else {
            LOG.info(ContainerLogger.getMessage(containerData, "Empty container deleted"));
        }
    }

    public static void logImported(ContainerData containerData) {
        LOG.info(ContainerLogger.getMessage(containerData));
    }

    public static void logExported(ContainerData containerData) {
        LOG.info(ContainerLogger.getMessage(containerData));
    }

    public static void logRecovered(ContainerData containerData) {
        LOG.info(ContainerLogger.getMessage(containerData));
    }

    private static String getMessage(ContainerData containerData, String message) {
        return String.join((CharSequence)FIELD_SEPARATOR, ContainerLogger.getMessage(containerData), message);
    }

    private static String getMessage(ContainerData containerData) {
        return String.join((CharSequence)FIELD_SEPARATOR, "ID=" + containerData.getContainerID(), "Index=" + containerData.getReplicaIndex(), "BCSID=" + containerData.getBlockCommitSequenceId(), "State=" + containerData.getState());
    }
}

