/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeUsage;

public class AvailableSpaceFilter
implements Predicate<HddsVolume> {
    private final long requiredSpace;
    private final Map<HddsVolume, AvailableSpace> fullVolumes = new HashMap<HddsVolume, AvailableSpace>();
    private long mostAvailableSpace = Long.MIN_VALUE;

    AvailableSpaceFilter(long requiredSpace) {
        this.requiredSpace = requiredSpace;
    }

    @Override
    public boolean test(HddsVolume vol) {
        long volumeCapacity = vol.getCapacity();
        long free = vol.getAvailable();
        long committed = vol.getCommittedBytes();
        long available = free - committed;
        long volumeFreeSpaceToSpare = VolumeUsage.getMinVolumeFreeSpace(vol.getConf(), volumeCapacity);
        boolean hasEnoughSpace = VolumeUsage.hasVolumeEnoughSpace(free, committed, this.requiredSpace, volumeFreeSpaceToSpare);
        this.mostAvailableSpace = Math.max(available, this.mostAvailableSpace);
        if (!hasEnoughSpace) {
            this.fullVolumes.put(vol, new AvailableSpace(free, committed));
        }
        return hasEnoughSpace;
    }

    boolean foundFullVolumes() {
        return !this.fullVolumes.isEmpty();
    }

    long mostAvailableSpace() {
        return this.mostAvailableSpace;
    }

    public String toString() {
        return "required space: " + this.requiredSpace + ", volumes: " + this.fullVolumes;
    }

    private static class AvailableSpace {
        private final long free;
        private final long committed;

        AvailableSpace(long free, long committed) {
            this.free = free;
            this.committed = committed;
        }

        public String toString() {
            return "free: " + this.free + ", committed: " + this.committed;
        }
    }
}

