/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.ratis.ContainerCommandRequestMessage;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.keyvalue.impl.StreamDataChannelBase;
import org.apache.hadoop.util.Time;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ratis.util.ReferenceCountedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStreamDataChannel
extends StreamDataChannelBase {
    public static final Logger LOG = LoggerFactory.getLogger(KeyValueStreamDataChannel.class);
    private final Buffers buffers = new Buffers(0x100000);
    private final AtomicReference<ContainerProtos.ContainerCommandRequestProto> putBlockRequest = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean();

    KeyValueStreamDataChannel(File file, ContainerData containerData, ContainerMetrics metrics) throws StorageContainerException {
        super(file, containerData, metrics);
    }

    @Override
    ContainerProtos.Type getType() {
        return ContainerProtos.Type.StreamWrite;
    }

    public int write(ReferenceCountedObject<ByteBuffer> referenceCounted) throws IOException {
        this.getMetrics().incContainerOpsMetrics(this.getType());
        this.assertOpen();
        long l = Time.monotonicNow();
        int len = KeyValueStreamDataChannel.writeBuffers(referenceCounted, this.buffers, x$0 -> super.writeFileChannel(x$0));
        this.getMetrics().incContainerOpsLatencies(this.getType(), Time.monotonicNow() - l);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int writeBuffers(ReferenceCountedObject<ByteBuffer> src, Buffers buffers, WriteMethod writeMethod) throws IOException {
        for (ReferenceCountedObject<ByteBuffer> b : buffers.offer(src)) {
            try {
                KeyValueStreamDataChannel.writeFully((ByteBuffer)b.get(), writeMethod);
            }
            finally {
                b.release();
            }
        }
        return ((ByteBuffer)src.get()).remaining();
    }

    private static void writeFully(ByteBuffer b, WriteMethod writeMethod) throws IOException {
        while (b.remaining() > 0) {
            int written = writeMethod.applyAsInt(b);
            if (written > 0) continue;
            throw new IOException("Unable to write");
        }
    }

    public ContainerProtos.ContainerCommandRequestProto getPutBlockRequest() {
        return Objects.requireNonNull(this.putBlockRequest.get(), () -> "putBlockRequest == null, " + this);
    }

    void assertOpen() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Already closed: " + this);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.putBlockRequest.set(KeyValueStreamDataChannel.closeBuffers(this.buffers, x$0 -> super.writeFileChannel(x$0)));
            }
            finally {
                super.close();
            }
        }
    }

    @Override
    protected void cleanupInternal() throws IOException {
        this.buffers.cleanUpAll();
        if (this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContainerProtos.ContainerCommandRequestProto closeBuffers(Buffers buffers, WriteMethod writeMethod) throws IOException {
        ContainerProtos.ContainerCommandRequestProto putBlockRequest;
        ReferenceCountedObject<ByteBuf> ref = buffers.pollAll();
        ByteBuf buf = (ByteBuf)ref.retain();
        try {
            putBlockRequest = KeyValueStreamDataChannel.readPutBlockRequest(buf);
            KeyValueStreamDataChannel.writeFully(buf.nioBuffer(), writeMethod);
        }
        finally {
            ref.release();
        }
        return putBlockRequest;
    }

    private static int readProtoLength(ByteBuf b, int lengthIndex) {
        int readerIndex = b.readerIndex();
        LOG.debug("{}, lengthIndex = {}, readerIndex = {}", new Object[]{b, lengthIndex, readerIndex});
        if (lengthIndex > readerIndex) {
            b.readerIndex(lengthIndex);
        } else {
            Preconditions.checkState((lengthIndex == readerIndex ? 1 : 0) != 0);
        }
        RatisHelper.debug((ByteBuf)b, (String)"readProtoLength", (Logger)LOG);
        return b.nioBuffer().getInt();
    }

    static ContainerProtos.ContainerCommandRequestProto readPutBlockRequest(ByteBuf b) throws IOException {
        ContainerProtos.ContainerCommandRequestProto proto;
        int readerIndex = b.readerIndex();
        int lengthIndex = readerIndex + b.readableBytes() - 4;
        int protoLength = KeyValueStreamDataChannel.readProtoLength(b.duplicate(), lengthIndex);
        int protoIndex = lengthIndex - protoLength;
        try {
            proto = KeyValueStreamDataChannel.readPutBlockRequest(b.slice(protoIndex, protoLength).nioBuffer());
        }
        catch (Throwable t) {
            RatisHelper.debug((ByteBuf)b, (String)"catch", (Logger)LOG);
            throw new IOException("Failed to readPutBlockRequest from " + b + ": readerIndex=" + readerIndex + ", protoIndex=" + protoIndex + ", protoLength=" + protoLength + ", lengthIndex=" + lengthIndex, t);
        }
        b.writerIndex(protoIndex);
        return proto;
    }

    private static ContainerProtos.ContainerCommandRequestProto readPutBlockRequest(ByteBuffer b) throws IOException {
        RatisHelper.debug((ByteBuffer)b, (String)"readPutBlockRequest", (Logger)LOG);
        ByteString byteString = ByteString.copyFrom((ByteBuffer)b);
        ContainerProtos.ContainerCommandRequestProto request = ContainerCommandRequestMessage.toProto((ByteString)byteString, null);
        if (!request.hasPutBlock()) {
            throw new StorageContainerException("Malformed PutBlock request. trace ID: " + request.getTraceID(), ContainerProtos.Result.MALFORMED_REQUEST);
        }
        return request;
    }

    static interface WriteMethod {
        public int applyAsInt(ByteBuffer var1) throws IOException;
    }

    static class Buffers {
        private final Deque<ReferenceCountedObject<ByteBuffer>> deque = new LinkedList<ReferenceCountedObject<ByteBuffer>>();
        private final int max;
        private int length;

        Buffers(int max) {
            this.max = max;
        }

        private boolean isExtra(int n) {
            return this.length - n >= this.max;
        }

        private boolean hasExtraBuffer() {
            return Optional.ofNullable(this.deque.peek()).map(ReferenceCountedObject::get).filter(b -> this.isExtra(b.remaining())).isPresent();
        }

        Iterable<ReferenceCountedObject<ByteBuffer>> offer(ReferenceCountedObject<ByteBuffer> ref) {
            ByteBuffer buffer = (ByteBuffer)ref.retain();
            LOG.debug("offer {}", (Object)buffer);
            boolean offered = this.deque.offer(ref);
            Preconditions.checkState((boolean)offered, (Object)"Failed to offer");
            this.length += buffer.remaining();
            return () -> new Iterator<ReferenceCountedObject<ByteBuffer>>(){

                @Override
                public boolean hasNext() {
                    return this.hasExtraBuffer();
                }

                @Override
                public ReferenceCountedObject<ByteBuffer> next() {
                    ReferenceCountedObject<ByteBuffer> polled = this.poll();
                    length = length - ((ByteBuffer)polled.get()).remaining();
                    Preconditions.checkState((length >= max ? 1 : 0) != 0);
                    return polled;
                }
            };
        }

        ReferenceCountedObject<ByteBuffer> poll() {
            ReferenceCountedObject<ByteBuffer> polled = Objects.requireNonNull(this.deque.poll());
            RatisHelper.debug((ByteBuffer)((ByteBuffer)polled.get()), (String)"polled", (Logger)LOG);
            return polled;
        }

        ReferenceCountedObject<ByteBuf> pollAll() {
            Preconditions.checkState((!this.deque.isEmpty() ? 1 : 0) != 0, (Object)"The deque is empty");
            ByteBuffer[] array = new ByteBuffer[this.deque.size()];
            ArrayList<ReferenceCountedObject<ByteBuffer>> refs = new ArrayList<ReferenceCountedObject<ByteBuffer>>(this.deque.size());
            for (int i = 0; i < array.length; ++i) {
                ReferenceCountedObject<ByteBuffer> ref = this.poll();
                refs.add(ref);
                array[i] = (ByteBuffer)ref.get();
            }
            ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer[])array).asReadOnly();
            return ReferenceCountedObject.wrap((Object)buf, () -> {}, () -> {
                buf.release();
                refs.forEach(ReferenceCountedObject::release);
            });
        }

        void cleanUpAll() {
            while (!this.deque.isEmpty()) {
                this.poll().release();
            }
        }
    }
}

