/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;

@InterfaceAudience.Private
@Metrics(about="Container Replication Supervisor Metrics", context="ozone")
public class ReplicationSupervisorMetrics
implements MetricsSource {
    public static final String SOURCE = ReplicationSupervisorMetrics.class.getSimpleName();
    private final ReplicationSupervisor supervisor;

    public ReplicationSupervisorMetrics(ReplicationSupervisor replicationSupervisor) {
        this.supervisor = replicationSupervisor;
    }

    public static ReplicationSupervisorMetrics create(ReplicationSupervisor supervisor) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (ReplicationSupervisorMetrics)ms.register(SOURCE, "Container Replication Supervisor Metrics", (Object)new ReplicationSupervisorMetrics(supervisor));
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(SOURCE);
        builder.addGauge(Interns.info((String)"numInFlightReplications", (String)"Total number of pending replications and reconstructions both low and normal priority"), this.supervisor.getTotalInFlightReplications()).addGauge(Interns.info((String)"numQueuedReplications", (String)"Number of replications in queue"), this.supervisor.getQueueSize()).addGauge(Interns.info((String)"numRequestedReplications", (String)"Number of requested replications"), this.supervisor.getReplicationRequestCount()).addGauge(Interns.info((String)"numTimeoutReplications", (String)"Number of replication requests timed out before being processed"), this.supervisor.getReplicationTimeoutCount()).addGauge(Interns.info((String)"numSkippedReplications", (String)"Number of replication requests skipped as the container is already present"), this.supervisor.getReplicationSkippedCount()).addGauge(Interns.info((String)"maxReplicationStreams", (String)"Maximum number of concurrent replication tasks which can run simultaneously"), this.supervisor.getMaxReplicationStreams());
        Map<String, Integer> tasks = this.supervisor.getInFlightReplicationSummary();
        for (Map.Entry<String, Integer> entry : tasks.entrySet()) {
            builder.addGauge(Interns.info((String)("numInflight" + entry.getKey()), (String)("Number of normal priority" + entry.getKey() + " tasks pending")), entry.getValue().intValue());
        }
    }
}

