/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.replication.ContainerImporter;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SendContainerRequestHandler
implements StreamObserver<ContainerProtos.SendContainerRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(SendContainerRequestHandler.class);
    private final ContainerImporter importer;
    private final StreamObserver<ContainerProtos.SendContainerResponse> responseObserver;
    private long containerId = -1L;
    private long nextOffset;
    private OutputStream output;
    private HddsVolume volume;
    private Path path;
    private CopyContainerCompression compression;

    SendContainerRequestHandler(ContainerImporter importer, StreamObserver<ContainerProtos.SendContainerResponse> responseObserver) {
        this.importer = importer;
        this.responseObserver = responseObserver;
    }

    public void onNext(ContainerProtos.SendContainerRequest req) {
        try {
            long length = req.getData().size();
            LOG.debug("Received part for container id:{} offset:{} len:{}", new Object[]{req.getContainerID(), req.getOffset(), length});
            Preconditions.assertSame((long)this.nextOffset, (long)req.getOffset(), (String)"offset");
            if (!this.importer.isAllowedContainerImport(req.getContainerID())) {
                this.containerId = req.getContainerID();
                throw new StorageContainerException("Container exists or import in progress with container Id " + req.getContainerID(), ContainerProtos.Result.CONTAINER_EXISTS);
            }
            if (this.containerId == -1L) {
                this.containerId = req.getContainerID();
                this.volume = this.importer.chooseNextVolume();
                Path dir = ContainerImporter.getUntarDirectory(this.volume);
                Files.createDirectories(dir, new FileAttribute[0]);
                this.path = dir.resolve(ContainerUtils.getContainerTarName(this.containerId));
                this.output = Files.newOutputStream(this.path, new OpenOption[0]);
                this.compression = CopyContainerCompression.fromProto(req.getCompression());
                LOG.info("Accepting container {}", (Object)req.getContainerID());
            }
            Preconditions.assertSame((long)this.containerId, (long)req.getContainerID(), (String)"containerID");
            req.getData().writeTo(this.output);
            this.nextOffset += length;
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    public void onError(Throwable t) {
        LOG.warn("Error receiving container {} at {}", new Object[]{this.containerId, this.nextOffset, t});
        this.closeOutput();
        this.deleteTarball();
        this.responseObserver.onError(t);
    }

    public void onCompleted() {
        if (this.output == null) {
            LOG.warn("Received container without any parts");
            return;
        }
        LOG.info("Container {} is downloaded with size {}, starting to import.", (Object)this.containerId, (Object)this.nextOffset);
        this.closeOutput();
        try {
            this.importer.importContainer(this.containerId, this.path, this.volume, this.compression);
            LOG.info("Container {} is replicated successfully", (Object)this.containerId);
            this.responseObserver.onNext((Object)ContainerProtos.SendContainerResponse.newBuilder().build());
            this.responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOG.warn("Failed to import container {}", (Object)this.containerId, (Object)t);
            this.deleteTarball();
            this.responseObserver.onError(t);
        }
    }

    private void closeOutput() {
        IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.output});
        this.output = null;
    }

    private void deleteTarball() {
        try {
            if (null != this.path) {
                Files.deleteIfExists(this.path);
            }
        }
        catch (IOException e) {
            LOG.warn("Error removing {}", (Object)this.path);
        }
    }
}

