/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.container.replication.ContainerDownloader;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.hadoop.ozone.container.replication.GrpcReplicationClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContainerDownloader
implements ContainerDownloader {
    public static final Logger LOG = LoggerFactory.getLogger(SimpleContainerDownloader.class);
    private final SecurityConfig securityConfig;
    private final CertificateClient certClient;

    public SimpleContainerDownloader(ConfigurationSource conf, CertificateClient certClient) {
        this.securityConfig = new SecurityConfig(conf);
        this.certClient = certClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Path getContainerDataFromReplicas(long containerId, List<DatanodeDetails> sourceDatanodes, Path downloadDir, CopyContainerCompression compression) {
        if (downloadDir == null) {
            downloadDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("container-copy");
        }
        List<DatanodeDetails> shuffledDatanodes = this.shuffleDatanodes(sourceDatanodes);
        for (int i = 0; i < shuffledDatanodes.size(); ++i) {
            Path path;
            DatanodeDetails datanode = shuffledDatanodes.get(i);
            GrpcReplicationClient client = null;
            try {
                client = this.createReplicationClient(datanode, compression);
                CompletableFuture<Path> result = this.downloadContainer(client, containerId, downloadDir);
                path = result.get();
            }
            catch (InterruptedException e) {
                SimpleContainerDownloader.logError(e, containerId, datanode, i, shuffledDatanodes.size());
                Thread.currentThread().interrupt();
                IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{client});
                continue;
            }
            catch (Exception e2) {
                SimpleContainerDownloader.logError(e2, containerId, datanode, i, shuffledDatanodes.size());
                {
                    catch (Throwable throwable) {
                        IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{client});
                        throw throwable;
                    }
                }
                IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{client});
                continue;
            }
            IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{client});
            return path;
        }
        LOG.error("Container {} could not be downloaded from any datanode", (Object)containerId);
        return null;
    }

    private static void logError(Exception e, long containerId, DatanodeDetails datanode, int datanodeIndex, int shuffledDatanodesSize) {
        StringBuilder sb = new StringBuilder("Error on replicating container: {} from {}. ");
        if (datanodeIndex < shuffledDatanodesSize - 1) {
            sb.append("Will try next datanode.");
        }
        LOG.error(sb.toString(), new Object[]{containerId, datanode, e});
    }

    @VisibleForTesting
    protected List<DatanodeDetails> shuffleDatanodes(List<DatanodeDetails> sourceDatanodes) {
        ArrayList<DatanodeDetails> shuffledDatanodes = new ArrayList<DatanodeDetails>(sourceDatanodes);
        Collections.shuffle(shuffledDatanodes);
        return shuffledDatanodes;
    }

    @VisibleForTesting
    protected GrpcReplicationClient createReplicationClient(DatanodeDetails datanode, CopyContainerCompression compression) throws IOException {
        return new GrpcReplicationClient(datanode.getIpAddress(), datanode.getPort(DatanodeDetails.Port.Name.REPLICATION).getValue(), this.securityConfig, this.certClient, compression);
    }

    @VisibleForTesting
    protected CompletableFuture<Path> downloadContainer(GrpcReplicationClient client, long containerId, Path downloadDir) {
        return client.download(containerId, downloadDir);
    }

    @Override
    public void close() {
    }
}

