/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.upgrade;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.UpgradeActionHdds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpgradeActionHdds(feature=HDDSLayoutFeature.SCM_HA, component=UpgradeActionHdds.Component.DATANODE, type=LayoutFeature.UpgradeActionType.ON_FINALIZE)
public class ScmHAFinalizeUpgradeActionDatanode
implements HDDSUpgradeAction<DatanodeStateMachine> {
    private static final Logger LOG = LoggerFactory.getLogger(ScmHAFinalizeUpgradeActionDatanode.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DatanodeStateMachine dsm) throws Exception {
        LOG.info("Upgrading Datanode volume layout for SCM HA support.");
        MutableVolumeSet volumeSet = dsm.getContainer().getVolumeSet();
        for (StorageVolume volume : volumeSet.getVolumesList()) {
            volumeSet.writeLock();
            try {
                HddsVolume hddsVolume;
                if (!(volume instanceof HddsVolume) || ScmHAFinalizeUpgradeActionDatanode.upgradeVolume(hddsVolume = (HddsVolume)volume, hddsVolume.getClusterID())) continue;
                volumeSet.failVolume(volume.getStorageDir().getAbsolutePath());
            }
            finally {
                volumeSet.writeUnlock();
            }
        }
    }

    public static boolean upgradeVolume(StorageVolume volume, String clusterID) {
        Preconditions.checkNotNull((Object)clusterID, (Object)"Cannot upgrade volume with null cluster ID");
        File hddsVolumeDir = volume.getStorageDir();
        File clusterIDDir = new File(hddsVolumeDir, clusterID);
        File[] storageDirs = volume.getStorageDir().listFiles(File::isDirectory);
        boolean success = true;
        if (storageDirs == null) {
            LOG.error("IO error for the volume {}. Unable to process it for finalizing layout for SCM HAsupport. Formatting will be retried on datanode restart.", (Object)volume.getStorageDir());
            success = false;
        } else if (storageDirs.length == 0) {
            LOG.info("Skipping finalize for SCM HA for unformatted volume {}, no action required.", (Object)hddsVolumeDir);
        } else if (storageDirs.length == 1) {
            if (!clusterIDDir.exists()) {
                File scmIDDir = storageDirs[0];
                Path relativeScmIDDir = hddsVolumeDir.toPath().relativize(scmIDDir.toPath());
                LOG.info("Creating symlink {} -> {} as part of SCM HA finalization for datanode.", (Object)clusterIDDir.getAbsolutePath(), (Object)relativeScmIDDir);
                try {
                    Files.createSymbolicLink(clusterIDDir.toPath(), relativeScmIDDir, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    LOG.error("IO error for the volume {}. Unable to process it for finalizing layout for SCM HAsupport. Formatting will be retried on datanode restart.", (Object)volume.getStorageDir(), (Object)ex);
                    success = false;
                }
            } else {
                LOG.info("Volume already contains cluster ID directory {}. No action required for SCM HA finalization.", (Object)clusterIDDir);
            }
        } else if (!clusterIDDir.exists()) {
            LOG.error("Volume {} is in an inconsistent state. Expected directory{} not found.", (Object)hddsVolumeDir, (Object)clusterIDDir);
            success = false;
        } else {
            LOG.info("Volume already contains cluster ID directory {}. No action required for SCM HA finalization.", (Object)clusterIDDir);
        }
        return success;
    }
}

