/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import java.io.IOException;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;

public final class FinalizeUpgradeCommandUtil {
    private FinalizeUpgradeCommandUtil() {
    }

    public static void handleInvalidRequestAfterInitiatingFinalization(boolean force, UpgradeException e) throws IOException {
        if (e.getResult().equals((Object)UpgradeException.ResultCodes.INVALID_REQUEST)) {
            if (force) {
                return;
            }
            System.err.println("Finalization is already in progress, it is notpossible to initiate it again.");
            e.printStackTrace(System.err);
            System.err.println("If you want to track progress from a new clientfor any reason, use --takeover, and the status update will bereceived by the new client. Note that with forcing to monitorprogress from a new client, the old one initiated the upgradewill not be able to monitor the progress further and exit.");
            throw new IOException("Exiting...");
        }
        throw e;
    }

    public static void emitExitMsg() {
        System.out.println("Exiting...");
    }

    public static boolean isFinalized(UpgradeFinalizer.Status status) {
        return status.equals((Object)UpgradeFinalizer.Status.ALREADY_FINALIZED);
    }

    public static boolean isDone(UpgradeFinalizer.Status status) {
        return status.equals((Object)UpgradeFinalizer.Status.FINALIZATION_DONE);
    }

    public static boolean isInprogress(UpgradeFinalizer.Status status) {
        return status.equals((Object)UpgradeFinalizer.Status.FINALIZATION_IN_PROGRESS);
    }

    public static boolean isStarting(UpgradeFinalizer.Status status) {
        return status.equals((Object)UpgradeFinalizer.Status.STARTING_FINALIZATION);
    }

    public static void emitGeneralErrorMsg() {
        System.err.println("Finalization was not successful.");
    }

    public static void emitFinishedMsg(String component) {
        System.out.println("Finalization of " + component + "'s metadata upgrade finished.");
    }

    public static void emitCancellationMsg(String component) {
        System.err.println("Finalization command was cancelled. Note that, thiswill not cancel finalization in " + component + ". Progress can bemonitored in the Ozone Manager's log.");
    }
}

