/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import picocli.CommandLine;

@CommandLine.Command(name="ombr", aliases={"om-bucket-remover"}, description={"Remove ozone buckets on OM side."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmBucketRemover
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the volume which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    private OzoneManagerProtocol ozoneManagerClient;
    private Timer bucketCreationTimer;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        try {
            this.ozoneManagerClient = this.createOmClient(ozoneConfiguration, this.omServiceID);
            this.bucketCreationTimer = this.getMetrics().timer("bucket-remove");
            this.runTests(this::removeBucket);
        }
        finally {
            if (this.ozoneManagerClient != null) {
                this.ozoneManagerClient.close();
            }
        }
        return null;
    }

    private void removeBucket(long index) throws Exception {
        String bucketName = this.generateBucketName(index);
        this.bucketCreationTimer.time(() -> {
            this.ozoneManagerClient.deleteBucket(this.volumeName, bucketName);
            return null;
        });
    }
}

