/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="ommg", aliases={"om-metadata-generator"}, description={"Create metadata operation to the OM."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmMetadataGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the volume which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Option(names={"-s", "--size"}, description={"The size in byte of a file for the Create File/Key op. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="0", converter={StorageSizeConverter.class})
    private StorageSize dataSize;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used to generated the key content."}, defaultValue="4096")
    private int bufferSize;
    @CommandLine.Option(names={"--batch-size"}, description={"The number of key/file requests per LIST_KEY/LIST_STATUS request."}, defaultValue="1000")
    private int batchSize;
    @CommandLine.Option(names={"--random"}, description={"random read/write if given. This means that it is possible to read/write the same file at the same time"}, defaultValue="false")
    private boolean randomOp;
    @CommandLine.Option(names={"-o", "--operation"}, description={"The operation to perform, --ophelp Print detail"})
    private Operation operation;
    @CommandLine.Option(names={"--ops"}, description={"The operations list to perform, --ophelp Print detail"})
    private String operationsList;
    @CommandLine.Option(names={"--opsnum"}, description={"The number of threads per operations, the values sum must equal the number of threads, --ophelp Print detail"})
    private String operationsNum;
    @CommandLine.Option(names={"--ophelp"}, description={"Print operation help, or list available operation"})
    private boolean opHelp;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID;
    private OzoneManagerProtocol ozoneManagerClient;
    private ThreadLocal<OmKeyArgs.Builder> omKeyArgsBuilder;
    private OzoneBucket bucket;
    private ContentGenerator contentGenerator;
    private final byte[] readBuffer = new byte[4096];
    private ReplicationConfig replicationConfig;
    private Operation[] operations;
    private boolean mixedOperation = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        if (this.opHelp || this.operation == null) {
            System.out.println(OmMetadataGenerator.getUsage());
            return null;
        }
        if (this.operation.equals((Object)Operation.MIXED)) {
            this.initMixedOperation();
            this.mixedOperation = true;
        }
        this.init();
        this.contentGenerator = new ContentGenerator(this.dataSize.toBytes(), this.bufferSize);
        this.omKeyArgsBuilder = ThreadLocal.withInitial(this::createKeyArgsBuilder);
        OzoneConfiguration conf = this.createOzoneConfiguration();
        this.replicationConfig = ReplicationConfig.getDefault((ConfigurationSource)conf);
        try (OzoneClient rpcClient = this.createOzoneClient(this.omServiceID, conf);){
            this.ensureVolumeAndBucketExist(rpcClient, this.volumeName, this.bucketName);
            this.ozoneManagerClient = this.createOmClient(conf, this.omServiceID);
            this.bucket = rpcClient.getObjectStore().getVolume(this.volumeName).getBucket(this.bucketName);
            this.runTests(this::applyOperation);
        }
        finally {
            if (this.ozoneManagerClient != null) {
                this.ozoneManagerClient.close();
                this.omKeyArgsBuilder.remove();
            }
        }
        return null;
    }

    private void initMixedOperation() {
        if (this.operationsList == null || this.operationsNum == null) {
            throw new IllegalArgumentException("--ops and --opsnum must be given, if --operation is MIXED");
        }
        List ops = Arrays.stream(this.operationsList.split(",")).map(Operation::valueOf).collect(Collectors.toList());
        List opsNum = Arrays.stream(this.operationsNum.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        if (ops.size() != opsNum.size() || opsNum.stream().mapToInt(x -> x).sum() != this.getThreadNo()) {
            throw new IllegalArgumentException("the --opsnum values sum must equal the number of threads");
        }
        int index = 0;
        this.operations = new Operation[this.getThreadNo()];
        for (int i = 0; i < ops.size(); ++i) {
            Operation op = (Operation)((Object)ops.get(i));
            int num = (Integer)opsNum.get(i);
            for (int j = 0; j < num; ++j) {
                this.operations[index] = op;
                ++index;
            }
        }
    }

    public static String getUsage() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A tool to measure the Ozone om performance", (Object)"support Operation: ", (Object)("  " + EnumSet.allOf(Operation.class).stream().map(Enum::toString).collect(Collectors.joining(", "))), (Object)"\nExample: ", (Object)"# create 25000 keys, run time 180s", (Object)"$ bin/ozone freon ommg --operation CREATE_KEY -n 25000 --duration  180s\n", (Object)"# read 25000 keys, run time 180s", (Object)"$ bin/ozone freon ommg --operation READ_KEY -n 25000 --duration 180s\n", (Object)"# 20 threads, list 1000 keys each request, and run time 180s", (Object)"$ bin/ozone freon ommg --operation LIST_KEYS -t 20 --batch-size 1000 --duration 180s\n", (Object)"# 10 threads, 1 threads list keys, 5 threads create file, 4 threads lookup file and run time 180s", (Object)"$ bin/ozone freon ommg --operation MIXED --ops CREATE_FILE,LOOKUP_FILE,LIST_STATUS --opsnum 5,4,1 -t 10 -n 1000 --duration 180s\n", (Object[])new String[]{"Note that: You must create a sufficient number of objects before executing read-related tests\n"}));
    }

    private OmKeyArgs.Builder createKeyArgsBuilder() {
        UserGroupInformation ugi = null;
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new OmKeyArgs.Builder().setBucketName(this.bucketName).setVolumeName(this.volumeName).setReplicationConfig(this.replicationConfig).setLocationInfoList(new ArrayList()).setAcls(OzoneAclUtil.getAclList((String)ugi.getUserName(), (String[])ugi.getGroupNames(), (IAccessAuthorizer.ACLType)IAccessAuthorizer.ACLType.ALL, (IAccessAuthorizer.ACLType)IAccessAuthorizer.ACLType.ALL));
    }

    private String getPath(long counter) {
        return StringUtils.leftPad((String)String.valueOf(counter), (int)19, (char)'0');
    }

    @Override
    public Supplier<String> realTimeStatusSupplier() {
        HashMap maxValueRecorder = new HashMap();
        HashMap valueRecorder = new HashMap();
        HashMap instantsRecorder = new HashMap();
        return () -> {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : this.getMetrics().getTimers(MetricFilter.ALL).entrySet()) {
                String name = (String)entry.getKey();
                long maxValue = maxValueRecorder.getOrDefault(name, -1L);
                long preValue = valueRecorder.getOrDefault(name, 0L);
                Instant preInstant = instantsRecorder.getOrDefault(name, Instant.now());
                long curValue = ((Timer)entry.getValue()).getCount();
                Instant now = Instant.now();
                long duration = Duration.between(preInstant, now).getSeconds();
                long rate = (curValue - preValue) / (duration == 0L ? 1L : duration);
                maxValue = Math.max(rate, maxValue);
                maxValueRecorder.put(name, maxValue);
                valueRecorder.put(name, curValue);
                instantsRecorder.put(name, now);
                sb.append(" ").append(name).append(": rate ").append(rate).append(" max ").append(maxValue);
            }
            sb.append("  ");
            return sb.toString();
        };
    }

    private void applyOperation(long counter) throws Exception {
        long threadSeqId;
        if (this.mixedOperation) {
            threadSeqId = this.getThreadSequenceId();
            this.operation = this.operations[(int)threadSeqId];
        }
        if (this.randomOp) {
            counter = ThreadLocalRandom.current().nextLong(this.getTestNo());
        }
        switch (this.operation) {
            case CREATE_KEY: {
                String keyName = this.getPath(counter);
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    try (OzoneDataStreamOutput stream = this.bucket.createStreamKey(keyName, this.dataSize.toBytes(), this.replicationConfig, new HashMap());){
                        this.contentGenerator.write((OutputStream)stream);
                    }
                    return null;
                });
                break;
            }
            case LOOKUP_KEY: {
                String keyName = this.getPath(counter);
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName(keyName).build();
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    this.ozoneManagerClient.lookupKey(keyArgs);
                    return null;
                });
                break;
            }
            case GET_KEYINFO: {
                String keyName = this.getPath(counter);
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName(keyName).build();
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    this.ozoneManagerClient.getKeyInfo(keyArgs, false);
                    return null;
                });
                break;
            }
            case HEAD_KEY: {
                String keyName = this.getPath(counter);
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName(keyName).setHeadOp(true).build();
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    this.ozoneManagerClient.getKeyInfo(keyArgs, false);
                    return null;
                });
                break;
            }
            case READ_KEY: {
                String keyName = this.getPath(counter);
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    try (OzoneInputStream stream = this.bucket.readKey(keyName);){
                        while (stream.read(this.readBuffer) >= 0) {
                        }
                    }
                    return null;
                });
                break;
            }
            case READ_FILE: {
                String keyName = this.getPath(counter);
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    try (OzoneInputStream stream = this.bucket.readFile(keyName);){
                        while (stream.read(this.readBuffer) >= 0) {
                        }
                    }
                    return null;
                });
                break;
            }
            case CREATE_FILE: {
                String keyName = this.getPath(counter);
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    try (OzoneOutputStream stream = this.bucket.createFile(keyName, this.dataSize.toBytes(), this.replicationConfig, true, false);){
                        this.contentGenerator.write((OutputStream)stream);
                    }
                    return null;
                });
                break;
            }
            case LOOKUP_FILE: {
                String keyName = this.getPath(counter);
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName(keyName).build();
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    this.ozoneManagerClient.lookupFile(keyArgs);
                    return null;
                });
                break;
            }
            case LIST_KEYS: {
                threadSeqId = this.getThreadSequenceId();
                String startKeyName = this.getPath(threadSeqId * (long)this.batchSize);
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    List keyInfoList = this.ozoneManagerClient.listKeys(this.volumeName, this.bucketName, startKeyName, "", this.batchSize).getKeys();
                    if (keyInfoList.size() + 1 < this.batchSize) {
                        throw new NoSuchFileException("There are not enough files for testing you should use CREATE_FILE to create at least batch-size * threads = " + this.batchSize * this.getThreadNo());
                    }
                    return null;
                });
                break;
            }
            case LIST_STATUS: {
                threadSeqId = this.getThreadSequenceId();
                String startKeyName = this.getPath(threadSeqId * (long)this.batchSize);
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName("").build();
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    List fileStatusList = this.ozoneManagerClient.listStatus(keyArgs, false, startKeyName, (long)this.batchSize);
                    if (fileStatusList.size() + 1 < this.batchSize) {
                        throw new NoSuchFileException("There are not enough files for testing you should use CREATE_FILE to create at least batch-size * threads = " + this.batchSize * this.getThreadNo());
                    }
                    return null;
                });
                break;
            }
            case INFO_BUCKET: {
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    try {
                        this.ozoneManagerClient.getBucketInfo(this.volumeName, this.bucketName);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                break;
            }
            case INFO_VOLUME: {
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    try {
                        this.ozoneManagerClient.getVolumeInfo(this.volumeName);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized write command type request " + (Object)((Object)this.operation));
            }
        }
    }

    static enum Operation {
        CREATE_FILE,
        LOOKUP_FILE,
        READ_FILE,
        LIST_STATUS,
        CREATE_KEY,
        LOOKUP_KEY,
        GET_KEYINFO,
        HEAD_KEY,
        READ_KEY,
        LIST_KEYS,
        INFO_BUCKET,
        INFO_VOLUME,
        MIXED;

    }
}

