/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"Updates the parameters of the bucket"})
public class UpdateBucketHandler
extends BucketHandler {
    @CommandLine.Option(names={"--user", "-u"}, description={"Owner of the bucket to set"})
    private String ownerName;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneBucket bucket = client.getObjectStore().getVolume(volumeName).getBucket(bucketName);
        if (this.ownerName != null && !this.ownerName.isEmpty()) {
            boolean result = bucket.setOwner(this.ownerName);
            if (LOG.isDebugEnabled() && !result) {
                this.out().format("Bucket '%s' owner is already '%s'. Unchanged.%n", volumeName + "/" + bucketName, this.ownerName);
            }
        }
        OzoneBucket updatedBucket = client.getObjectStore().getVolume(volumeName).getBucket(bucketName);
        this.printObjectAsJson(updatedBucket);
    }
}

