/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.ShellReplicationOptions;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import picocli.CommandLine;

@CommandLine.Command(name="put", description={"creates or overwrites an existing key"})
public class PutKeyHandler
extends KeyHandler {
    @CommandLine.Parameters(index="1", arity="1..1", description={"File to upload"})
    private String fileName;
    @CommandLine.Option(names={"--stream"})
    private boolean stream;
    @CommandLine.Mixin
    private ShellReplicationOptions replication;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        String keyName = address.getKeyName();
        File dataFile = new File(this.fileName);
        if (this.isVerbose()) {
            try (FileInputStream stream = new FileInputStream(dataFile);){
                String hash = DigestUtils.sha256Hex((InputStream)stream);
                this.out().printf("File sha256 checksum : %s%n", hash);
            }
        }
        ReplicationConfig replicationConfig = this.replication.fromParamsOrConfig((ConfigurationSource)this.getConf());
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        HashMap<String, String> keyMetadata = new HashMap<String, String>();
        String gdprEnabled = (String)bucket.getMetadata().get("gdprEnabled");
        if (Boolean.parseBoolean(gdprEnabled)) {
            keyMetadata.put("gdprEnabled", Boolean.TRUE.toString());
        }
        int chunkSize = (int)this.getConf().getStorageSize("ozone.scm.chunk.size", "4MB", StorageUnit.BYTES);
        if (this.stream) {
            this.stream(dataFile, bucket, keyName, keyMetadata, replicationConfig, chunkSize);
        } else {
            this.async(dataFile, bucket, keyName, keyMetadata, replicationConfig, chunkSize);
        }
    }

    void async(File dataFile, OzoneBucket bucket, String keyName, Map<String, String> keyMetadata, ReplicationConfig replicationConfig, int chunkSize) throws IOException {
        if (this.isVerbose()) {
            this.out().println("API: async");
        }
        try (FileInputStream input = new FileInputStream(dataFile);
             OzoneOutputStream output = bucket.createKey(keyName, dataFile.length(), replicationConfig, keyMetadata);){
            IOUtils.copyBytes((InputStream)input, (OutputStream)output, (int)chunkSize);
        }
    }

    void stream(File dataFile, OzoneBucket bucket, String keyName, Map<String, String> keyMetadata, ReplicationConfig replicationConfig, int chunkSize) throws IOException {
        if (this.isVerbose()) {
            this.out().println("API: streaming");
        }
        Preconditions.checkArgument((!((replicationConfig = ReplicationConfig.resolve((ReplicationConfig)replicationConfig, (ReplicationConfig)bucket.getReplicationConfig(), (ConfigurationSource)this.getConf())) instanceof ECReplicationConfig) ? 1 : 0) != 0, (Object)"Can not put EC key by streaming");
        try (RandomAccessFile raf = new RandomAccessFile(dataFile, "r");
             OzoneDataStreamOutput out = bucket.createStreamKey(keyName, dataFile.length(), replicationConfig, keyMetadata);){
            long writeLen;
            FileChannel ch = raf.getChannel();
            long off = 0L;
            for (long len = raf.length(); len > 0L; len -= writeLen) {
                writeLen = Math.min(len, (long)chunkSize);
                MappedByteBuffer bb = ch.map(FileChannel.MapMode.READ_ONLY, off, writeLen);
                out.write((ByteBuffer)bb);
                off += writeLen;
            }
        }
    }
}

