/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.snapshot;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete a snapshot"})
public class DeleteSnapshotHandler
extends Handler {
    @CommandLine.Mixin
    private BucketUri snapshotPath;
    @CommandLine.Parameters(description={"Snapshot name"}, index="1", arity="1")
    private String snapshotName;

    @Override
    protected OzoneAddress getAddress() {
        return this.snapshotPath.getValue();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = this.snapshotPath.getValue().getVolumeName();
        String bucketName = this.snapshotPath.getValue().getBucketName();
        client.getObjectStore().deleteSnapshot(volumeName, bucketName, this.snapshotName);
        if (this.isVerbose()) {
            this.out().format("Deleted snapshot '%s' under '%s/%s'.%n", this.snapshotName, volumeName, bucketName);
        }
    }
}

