/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.annotations;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class RequestFeatureValidatorProcessor
extends AbstractProcessor {
    public static final String ERROR_CONDITION_IS_EMPTY = "RequestFeatureValidator has an empty condition list. Please define the ValidationCondition in which the validator has to be applied.";
    public static final String ERROR_ANNOTATED_ELEMENT_IS_NOT_A_METHOD = "RequestFeatureValidator annotation is not applied to a method.";
    public static final String ERROR_VALIDATOR_METHOD_HAS_TO_BE_STATIC = "Only static methods can be annotated with the RequestFeatureValidator annotation.";
    public static final String ERROR_UNEXPECTED_PARAMETER_COUNT = "Unexpected parameter count. Expected: %d; found: %d.";
    public static final String ERROR_VALIDATOR_METHOD_HAS_TO_RETURN_OMREQUEST = "Pre-processing validator methods annotated with RequestFeatureValidator annotation has to return an OMRequest object.";
    public static final String ERROR_VALIDATOR_METHOD_HAS_TO_RETURN_OMRESPONSE = "Post-processing validator methods annotated with RequestFeatureValidator annotation has to return an OMResponse object.";
    public static final String ERROR_FIRST_PARAM_HAS_TO_BE_OMREQUEST = "First parameter of a RequestFeatureValidator method has to be an OMRequest object.";
    public static final String ERROR_LAST_PARAM_HAS_TO_BE_VALIDATION_CONTEXT = "Last parameter of a RequestFeatureValidator method has to be ValidationContext object.";
    public static final String ERROR_SECOND_PARAM_HAS_TO_BE_OMRESPONSE = "Second parameter of a RequestFeatureValidator method has to be an OMResponse object.";
    public static final String OM_REQUEST_CLASS_NAME = "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos.OMRequest";
    public static final String OM_RESPONSE_CLASS_NAME = "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos.OMResponse";
    public static final String VALIDATION_CONTEXT_CLASS_NAME = "org.apache.hadoop.ozone.om.request.validation.ValidationContext";
    public static final String ANNOTATION_SIMPLE_NAME = "RequestFeatureValidator";
    public static final String ANNOTATION_CONDITIONS_PROPERTY_NAME = "conditions";
    public static final String ANNOTATION_PROCESSING_PHASE_PROPERTY_NAME = "processingPhase";
    public static final String PROCESSING_PHASE_PRE_PROCESS = "PRE_PROCESS";
    public static final String PROCESSING_PHASE_POST_PROCESS = "POST_PROCESS";
    public static final String ERROR_NO_PROCESSING_PHASE_DEFINED = "RequestFeatureValidator has an invalid ProcessingPhase defined.";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            if (!typeElement.getSimpleName().contentEquals(ANNOTATION_SIMPLE_NAME)) continue;
            this.processElements(roundEnv.getElementsAnnotatedWith(typeElement));
        }
        return false;
    }

    private void processElements(Set<? extends Element> annotatedElements) {
        for (Element element : annotatedElements) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                this.validateAnnotatedMethod(element, annotationMirror);
            }
        }
    }

    private void validateAnnotatedMethod(Element elem, AnnotationMirror methodAnnotation) {
        boolean isPreprocessor = this.checkAndEvaluateAnnotation(methodAnnotation);
        this.checkMethodIsAnnotated(elem);
        this.ensureAnnotatedMethodIsStatic(elem);
        this.ensurePreProcessorReturnsOMReqest((ExecutableElement)elem, isPreprocessor);
        this.ensurePostProcessorReturnsOMResponse((ExecutableElement)elem, isPreprocessor);
        this.ensureMethodParameters(elem, isPreprocessor);
    }

    private void ensureMethodParameters(Element elem, boolean isPreprocessor) {
        List<? extends TypeMirror> paramTypes = ((ExecutableType)elem.asType()).getParameterTypes();
        this.ensureParameterCount(isPreprocessor, paramTypes);
        this.ensureParameterRequirements(paramTypes, 0, OM_REQUEST_CLASS_NAME, ERROR_FIRST_PARAM_HAS_TO_BE_OMREQUEST);
        if (!isPreprocessor) {
            this.ensureParameterRequirements(paramTypes, 1, OM_RESPONSE_CLASS_NAME, ERROR_SECOND_PARAM_HAS_TO_BE_OMRESPONSE);
        }
        int contextOrder = isPreprocessor ? 1 : 2;
        this.ensureParameterRequirements(paramTypes, contextOrder, VALIDATION_CONTEXT_CLASS_NAME, ERROR_LAST_PARAM_HAS_TO_BE_VALIDATION_CONTEXT);
    }

    private void ensureParameterCount(boolean isPreprocessor, List<? extends TypeMirror> paramTypes) {
        int expectedParamCount;
        int realParamCount = paramTypes.size();
        int n = expectedParamCount = isPreprocessor ? 2 : 3;
        if (realParamCount != expectedParamCount) {
            this.emitErrorMsg(String.format(ERROR_UNEXPECTED_PARAMETER_COUNT, expectedParamCount, realParamCount));
        }
    }

    private void ensureParameterRequirements(List<? extends TypeMirror> paramTypes, int index, String validationContextClassName, String errorLastParamHasToBeValidationContext) {
        if (paramTypes.size() >= index + 1 && !paramTypes.get(index).toString().equals(validationContextClassName)) {
            this.emitErrorMsg(errorLastParamHasToBeValidationContext);
        }
    }

    private void ensurePostProcessorReturnsOMResponse(ExecutableElement elem, boolean isPreprocessor) {
        if (!isPreprocessor && !elem.getReturnType().toString().equals(OM_RESPONSE_CLASS_NAME)) {
            this.emitErrorMsg(ERROR_VALIDATOR_METHOD_HAS_TO_RETURN_OMRESPONSE);
        }
    }

    private void ensurePreProcessorReturnsOMReqest(ExecutableElement elem, boolean isPreprocessor) {
        if (isPreprocessor && !elem.getReturnType().toString().equals(OM_REQUEST_CLASS_NAME)) {
            this.emitErrorMsg(ERROR_VALIDATOR_METHOD_HAS_TO_RETURN_OMREQUEST);
        }
    }

    private void ensureAnnotatedMethodIsStatic(Element elem) {
        if (!elem.getModifiers().contains((Object)Modifier.STATIC)) {
            this.emitErrorMsg(ERROR_VALIDATOR_METHOD_HAS_TO_BE_STATIC);
        }
    }

    private void checkMethodIsAnnotated(Element elem) {
        if (elem.getKind() != ElementKind.METHOD) {
            this.emitErrorMsg(ERROR_ANNOTATED_ELEMENT_IS_NOT_A_METHOD);
        }
    }

    private boolean checkAndEvaluateAnnotation(AnnotationMirror methodAnnotation) {
        boolean isPreprocessor = false;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : methodAnnotation.getElementValues().entrySet()) {
            if (this.hasInvalidValidationCondition(entry)) {
                this.emitErrorMsg(ERROR_CONDITION_IS_EMPTY);
            }
            if (!this.isProcessingPhaseValue(entry)) continue;
            isPreprocessor = this.evaluateProcessingPhase(entry);
        }
        return isPreprocessor;
    }

    private boolean evaluateProcessingPhase(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        String procPhase = this.visit(entry, new ProcessingPhaseVisitor());
        if (procPhase.equals(PROCESSING_PHASE_PRE_PROCESS)) {
            return true;
        }
        if (procPhase.equals(PROCESSING_PHASE_POST_PROCESS)) {
            return false;
        }
        return false;
    }

    private boolean isProcessingPhaseValue(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        return this.isPropertyNamedAs(entry, ANNOTATION_PROCESSING_PHASE_PROPERTY_NAME);
    }

    private boolean hasInvalidValidationCondition(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        return this.isPropertyNamedAs(entry, ANNOTATION_CONDITIONS_PROPERTY_NAME) && this.visit(entry, new ConditionValidator()) == false;
    }

    private boolean isPropertyNamedAs(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry, String simpleName) {
        return entry.getKey().getSimpleName().contentEquals(simpleName);
    }

    private <T> T visit(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry, AnnotationValueVisitor<T, Void> visitor) {
        return entry.getValue().accept(visitor, null);
    }

    private void emitErrorMsg(String s) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, s);
    }

    private static class ProcessingPhaseVisitor
    extends SimpleAnnotationValueVisitor8<String, Void> {
        ProcessingPhaseVisitor() {
            super("UNKNOWN");
        }

        @Override
        public String visitEnumConstant(VariableElement c, Void unused) {
            if (c.getSimpleName().contentEquals(RequestFeatureValidatorProcessor.PROCESSING_PHASE_PRE_PROCESS)) {
                return RequestFeatureValidatorProcessor.PROCESSING_PHASE_PRE_PROCESS;
            }
            if (c.getSimpleName().contentEquals(RequestFeatureValidatorProcessor.PROCESSING_PHASE_POST_PROCESS)) {
                return RequestFeatureValidatorProcessor.PROCESSING_PHASE_POST_PROCESS;
            }
            throw new IllegalStateException(RequestFeatureValidatorProcessor.ERROR_NO_PROCESSING_PHASE_DEFINED);
        }
    }

    private static class ConditionValidator
    extends SimpleAnnotationValueVisitor8<Boolean, Void> {
        ConditionValidator() {
            super(Boolean.TRUE);
        }

        @Override
        public Boolean visitArray(List<? extends AnnotationValue> vals, Void unused) {
            if (vals.isEmpty()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }
}

