/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.management.ObjectName;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.block.BlockmanagerMXBean;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;
import org.apache.hadoop.hdds.scm.block.ScmBlockDeletingServiceMetrics;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.SequenceIdGenerator;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.WritableContainerFactory;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManagerImpl
implements BlockManager,
BlockmanagerMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(BlockManagerImpl.class);
    private final StorageContainerManager scm;
    private final PipelineManager pipelineManager;
    private final WritableContainerFactory writableContainerFactory;
    private final long containerSize;
    private DeletedBlockLog deletedBlockLog;
    private final SCMBlockDeletingService blockDeletingService;
    private ObjectName mxBean;
    private final SequenceIdGenerator sequenceIdGen;
    private ScmBlockDeletingServiceMetrics metrics;

    public BlockManagerImpl(ConfigurationSource conf, ScmConfig scmConfig, StorageContainerManager scm) throws IOException {
        Objects.requireNonNull(scm, "SCM cannot be null");
        this.scm = scm;
        this.pipelineManager = scm.getPipelineManager();
        this.sequenceIdGen = scm.getSequenceIdGen();
        this.containerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.writableContainerFactory = scm.getWritableContainerFactory();
        this.mxBean = MBeans.register((String)"BlockManager", (String)"BlockManagerImpl", (Object)this);
        this.metrics = ScmBlockDeletingServiceMetrics.create();
        this.deletedBlockLog = new DeletedBlockLogImpl(conf, scm.getContainerManager(), scm.getScmHAManager().getRatisServer(), (Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)scm.getScmMetadataStore().getDeletedBlocksTXTable(), scm.getScmHAManager().getDBTransactionBuffer(), scm.getScmContext(), scm.getSequenceIdGen(), this.metrics);
        this.blockDeletingService = new SCMBlockDeletingService(this.deletedBlockLog, scm.getScmNodeManager(), scm.getEventQueue(), scm.getScmContext(), scm.getSCMServiceManager(), conf, scmConfig, this.metrics, scm.getSystemClock(), scm.getReconfigurationHandler());
    }

    @Override
    public void start() throws IOException {
        this.blockDeletingService.start();
    }

    @Override
    public void stop() throws IOException {
        this.blockDeletingService.shutdown();
        this.close();
    }

    @Override
    public AllocatedBlock allocateBlock(long size, ReplicationConfig replicationConfig, String owner, ExcludeList excludeList) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Size : {} , replicationConfig: {}", (Object)size, (Object)replicationConfig);
        }
        if (this.scm.getScmContext().isInSafeMode()) {
            throw new SCMException("SafeModePrecheck failed for allocateBlock", SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
        }
        if (size < 0L || size > this.containerSize) {
            LOG.warn("Invalid block size requested : {}", (Object)size);
            throw new SCMException("Unsupported block size: " + size, SCMException.ResultCodes.INVALID_BLOCK_SIZE);
        }
        ContainerInfo containerInfo = this.writableContainerFactory.getContainer(size, replicationConfig, owner, excludeList);
        if (containerInfo != null) {
            return this.newBlock(containerInfo);
        }
        LOG.error("Unable to allocate a block for the size: {}, replicationConfig: {}", (Object)size, (Object)replicationConfig);
        return null;
    }

    private AllocatedBlock newBlock(ContainerInfo containerInfo) throws SCMException {
        try {
            Pipeline pipeline = this.pipelineManager.getPipeline(containerInfo.getPipelineID());
            long localID = this.sequenceIdGen.getNextId("localId");
            long containerID = containerInfo.getContainerID();
            AllocatedBlock.Builder abb = new AllocatedBlock.Builder().setContainerBlockID(new ContainerBlockID(containerID, localID)).setPipeline(pipeline);
            if (LOG.isTraceEnabled()) {
                LOG.trace("New block allocated : {} Container ID: {}", (Object)localID, (Object)containerID);
            }
            this.pipelineManager.incNumBlocksAllocatedMetric(pipeline.getId());
            return abb.build();
        }
        catch (PipelineNotFoundException ex) {
            LOG.error("Pipeline Machine count is zero.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void deleteBlocks(List<BlockGroup> keyBlocksInfoList) throws IOException {
        if (this.scm.getScmContext().isInSafeMode()) {
            throw new SCMException("SafeModePrecheck failed for deleteBlocks", SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
        }
        HashMap<Long, List<Long>> containerBlocks = new HashMap<Long, List<Long>>();
        for (BlockGroup bg : keyBlocksInfoList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting blocks {}", (Object)StringUtils.join((CharSequence)",", (Iterable)bg.getBlockIDList()));
            }
            for (BlockID block : bg.getBlockIDList()) {
                long containerID = block.getContainerID();
                if (containerBlocks.containsKey(containerID)) {
                    ((List)containerBlocks.get(containerID)).add(block.getLocalID());
                    continue;
                }
                ArrayList<Long> item = new ArrayList<Long>();
                item.add(block.getLocalID());
                containerBlocks.put(containerID, item);
            }
        }
        try {
            this.deletedBlockLog.addTransactions(containerBlocks);
        }
        catch (IOException e) {
            throw new IOException("Skip writing the deleted blocks info to the delLog because addTransaction fails. " + keyBlocksInfoList.size() + "Keys skipped", e);
        }
    }

    @Override
    public DeletedBlockLog getDeletedBlockLog() {
        return this.deletedBlockLog;
    }

    @Override
    public void close() throws IOException {
        if (this.deletedBlockLog != null) {
            this.deletedBlockLog.close();
        }
        this.blockDeletingService.shutdown();
        if (this.metrics != null) {
            ScmBlockDeletingServiceMetrics.unRegister();
            this.metrics = null;
        }
        if (this.mxBean != null) {
            MBeans.unregister((ObjectName)this.mxBean);
            this.mxBean = null;
        }
    }

    @Override
    public SCMBlockDeletingService getSCMBlockDeletingService() {
        return this.blockDeletingService;
    }

    public static Logger getLogger() {
        return LOG;
    }
}

