/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(name="ScmBlockDeletingService Metrics", about="Metrics related to background block deleting service in SCM", context="SCM")
public final class ScmBlockDeletingServiceMetrics {
    private static ScmBlockDeletingServiceMetrics instance;
    public static final String SOURCE_NAME;
    @Metric(about="The number of individual delete transaction commands sent to all DN.")
    private MutableCounterLong numBlockDeletionCommandSent;
    @Metric(about="The number of success ACK of delete transaction commands.")
    private MutableCounterLong numBlockDeletionCommandSuccess;
    @Metric(about="The number of failure ACK of delete transaction commands.")
    private MutableCounterLong numBlockDeletionCommandFailure;
    @Metric(about="The number of individual delete transactions sent to all DN.")
    private MutableCounterLong numBlockDeletionTransactionSent;
    @Metric(about="The number of success execution of delete transactions.")
    private MutableCounterLong numBlockDeletionTransactionSuccess;
    @Metric(about="The number of failure execution of delete transactions.")
    private MutableCounterLong numBlockDeletionTransactionFailure;
    @Metric(about="The number of completed txs which are removed from DB.")
    private MutableCounterLong numBlockDeletionTransactionCompleted;
    @Metric(about="The number of created txs which are added into DB.")
    private MutableCounterLong numBlockDeletionTransactionCreated;
    @Metric(about="The number of skipped transactions")
    private MutableCounterLong numSkippedTransactions;
    @Metric(about="The number of processed transactions")
    private MutableCounterLong numProcessedTransactions;
    @Metric(about="The number of dataNodes of delete transactions.")
    private MutableGaugeLong numBlockDeletionTransactionDataNodes;

    private ScmBlockDeletingServiceMetrics() {
    }

    public static ScmBlockDeletingServiceMetrics create() {
        if (instance == null) {
            MetricsSystem ms = DefaultMetricsSystem.instance();
            instance = (ScmBlockDeletingServiceMetrics)ms.register(SOURCE_NAME, "SCMBlockDeletingService", (Object)new ScmBlockDeletingServiceMetrics());
        }
        return instance;
    }

    public static void unRegister() {
        instance = null;
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void incrBlockDeletionCommandSent() {
        this.numBlockDeletionCommandSent.incr();
    }

    public void incrBlockDeletionCommandSuccess() {
        this.numBlockDeletionCommandSuccess.incr();
    }

    public void incrBlockDeletionCommandFailure() {
        this.numBlockDeletionCommandFailure.incr();
    }

    public void incrBlockDeletionTransactionSent(long count) {
        this.numBlockDeletionTransactionSent.incr(count);
    }

    public void incrBlockDeletionTransactionFailure() {
        this.numBlockDeletionTransactionFailure.incr();
    }

    public void incrBlockDeletionTransactionSuccess() {
        this.numBlockDeletionTransactionSuccess.incr();
    }

    public void incrBlockDeletionTransactionCompleted(long count) {
        this.numBlockDeletionTransactionCompleted.incr(count);
    }

    public void incrBlockDeletionTransactionCreated(long count) {
        this.numBlockDeletionTransactionCreated.incr(count);
    }

    public void incrSkippedTransaction() {
        this.numSkippedTransactions.incr();
    }

    public void incrProcessedTransaction() {
        this.numProcessedTransactions.incr();
    }

    public void setNumBlockDeletionTransactionDataNodes(long dataNodes) {
        this.numBlockDeletionTransactionDataNodes.set(dataNodes);
    }

    public long getNumBlockDeletionCommandSent() {
        return this.numBlockDeletionCommandSent.value();
    }

    public long getNumBlockDeletionCommandSuccess() {
        return this.numBlockDeletionCommandSuccess.value();
    }

    public long getBNumBlockDeletionCommandFailure() {
        return this.numBlockDeletionCommandFailure.value();
    }

    public long getNumBlockDeletionTransactionSent() {
        return this.numBlockDeletionTransactionSent.value();
    }

    public long getNumBlockDeletionTransactionFailure() {
        return this.numBlockDeletionTransactionFailure.value();
    }

    public long getNumBlockDeletionTransactionSuccess() {
        return this.numBlockDeletionTransactionSuccess.value();
    }

    public long getNumBlockDeletionTransactionCompleted() {
        return this.numBlockDeletionTransactionCompleted.value();
    }

    public long getNumBlockDeletionTransactionCreated() {
        return this.numBlockDeletionTransactionCreated.value();
    }

    public long getNumSkippedTransactions() {
        return this.numSkippedTransactions.value();
    }

    public long getNumProcessedTransactions() {
        return this.numProcessedTransactions.value();
    }

    public long getNumBlockDeletionTransactionDataNodes() {
        return this.numBlockDeletionTransactionDataNodes.value();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("numBlockDeletionTransactionCreated = " + this.numBlockDeletionTransactionCreated.value()).append("\t").append("numBlockDeletionTransactionCompleted = " + this.numBlockDeletionTransactionCompleted.value()).append("\t").append("numBlockDeletionCommandSent = " + this.numBlockDeletionCommandSent.value()).append("\t").append("numBlockDeletionCommandSuccess = " + this.numBlockDeletionCommandSuccess.value()).append("\t").append("numBlockDeletionCommandFailure = " + this.numBlockDeletionCommandFailure.value()).append("\t").append("numBlockDeletionTransactionSent = " + this.numBlockDeletionTransactionSent.value()).append("\t").append("numBlockDeletionTransactionSuccess = " + this.numBlockDeletionTransactionSuccess.value()).append("\t").append("numBlockDeletionTransactionFailure = " + this.numBlockDeletionTransactionFailure.value());
        return buffer.toString();
    }

    static {
        SOURCE_NAME = SCMBlockDeletingService.class.getSimpleName();
    }
}

