/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ECContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.MisReplicationHandler;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;

public class ECMisReplicationHandler
extends MisReplicationHandler {
    public ECMisReplicationHandler(PlacementPolicy containerPlacement, ConfigurationSource conf, ReplicationManager replicationManager) {
        super(containerPlacement, conf, replicationManager);
    }

    @Override
    protected ContainerReplicaCount getContainerReplicaCount(ContainerInfo containerInfo, Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, int remainingMaintenanceRedundancy) throws IOException {
        if (containerInfo.getReplicationType() != HddsProtos.ReplicationType.EC) {
            throw new IOException(String.format("Invalid Container Replication Type : %s.Expected Container Replication Type : EC", containerInfo.getReplicationType().toString()));
        }
        return new ECContainerReplicaCount(containerInfo, replicas, pendingOps, remainingMaintenanceRedundancy);
    }

    @Override
    protected int sendReplicateCommands(ContainerInfo containerInfo, Set<ContainerReplica> replicasToBeReplicated, List<DatanodeDetails> sources, List<DatanodeDetails> targetDns) throws CommandTargetOverloadedException, NotLeaderException {
        ReplicationManager replicationManager = this.getReplicationManager();
        int commandsSent = 0;
        int datanodeIdx = 0;
        CommandTargetOverloadedException overloadedException = null;
        for (ContainerReplica replica : replicasToBeReplicated) {
            if (datanodeIdx == targetDns.size()) break;
            long containerID = containerInfo.getContainerID();
            DatanodeDetails source = replica.getDatanodeDetails();
            DatanodeDetails target = targetDns.get(datanodeIdx);
            try {
                if (replicationManager.getConfig().isPush()) {
                    replicationManager.sendThrottledReplicationCommand(containerInfo, Collections.singletonList(source), target, replica.getReplicaIndex());
                } else {
                    ReplicateContainerCommand cmd = ReplicateContainerCommand.fromSources((long)containerID, Collections.singletonList(source));
                    cmd.setReplicaIndex(replica.getReplicaIndex());
                    replicationManager.sendDatanodeCommand((SCMCommand<?>)cmd, containerInfo, target);
                }
                ++commandsSent;
            }
            catch (CommandTargetOverloadedException e) {
                LOG.debug("Unable to replicate container {} and index {} from {} to {} because the source is overloaded", new Object[]{containerID, replica.getReplicaIndex(), source, target});
                overloadedException = e;
            }
            ++datanodeIdx;
        }
        if (overloadedException != null) {
            throw overloadedException;
        }
        return commandsSent;
    }
}

