/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.base.CaseFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.InflightType;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@Metrics(about="Replication Manager Metrics", context="ozone")
public final class ReplicationManagerMetrics
implements MetricsSource {
    public static final String METRICS_SOURCE_NAME = ReplicationManagerMetrics.class.getSimpleName();
    private static final MetricsInfo INFLIGHT_REPLICATION = Interns.info((String)"InflightReplication", (String)"Tracked inflight container replication requests.");
    private static final MetricsInfo INFLIGHT_REPLICATION_SKIPPED = Interns.info((String)"InflightReplicationSkipped", (String)"Tracked inflight container replication requests skipped due to the configured limit.");
    private static final MetricsInfo INFLIGHT_DELETION = Interns.info((String)"InflightDeletion", (String)"Tracked inflight container deletion requests.");
    private static final MetricsInfo INFLIGHT_DELETION_SKIPPED = Interns.info((String)"InflightDeletionSkipped", (String)"Tracked inflight container deletion requests skipped due to the configured limit.");
    private static final MetricsInfo INFLIGHT_MOVE = Interns.info((String)"InflightMove", (String)"Tracked inflight container move requests.");
    private static final MetricsInfo INFLIGHT_EC_REPLICATION = Interns.info((String)"InflightEcReplication", (String)"Tracked inflight EC container replication requests.");
    private static final MetricsInfo INFLIGHT_EC_DELETION = Interns.info((String)"InflightEcDeletion", (String)"Tracked inflight EC container deletion requests.");
    private static final MetricsInfo UNDER_REPLICATED_QUEUE = Interns.info((String)"UnderReplicatedQueueSize", (String)"Number of containers currently in the under replicated queue");
    private static final MetricsInfo OVER_REPLICATED_QUEUE = Interns.info((String)"OverReplicatedQueueSize", (String)"Number of containers currently in the over replicated queue");
    private static final Map<HddsProtos.LifeCycleState, MetricsInfo> LIFECYCLE_STATE_METRICS = Collections.unmodifiableMap(new LinkedHashMap<HddsProtos.LifeCycleState, MetricsInfo>(){
        {
            for (HddsProtos.LifeCycleState s : HddsProtos.LifeCycleState.values()) {
                String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s.toString());
                String metric = name + "Containers";
                String description = "Current count of Containers in " + name + " state";
                this.put(s, Interns.info((String)metric, (String)description));
            }
        }
    });
    private static final Map<ReplicationManagerReport.HealthState, MetricsInfo> CONTAINER_HEALTH_STATE_METRICS = Collections.unmodifiableMap(new LinkedHashMap<ReplicationManagerReport.HealthState, MetricsInfo>(){
        {
            for (ReplicationManagerReport.HealthState s : ReplicationManagerReport.HealthState.values()) {
                this.put(s, Interns.info((String)s.getMetricName(), (String)s.getDescription()));
            }
        }
    });
    @Metric(value={"Number of replication commands sent."})
    private MutableCounterLong replicationCmdsSentTotal;
    @Metric(value={"Number of container replicas created successfully."})
    private MutableCounterLong replicasCreatedTotal;
    @Metric(value={"Number of container replicas which timed out before being created."})
    private MutableCounterLong replicaCreateTimeoutTotal;
    @Metric(value={"Number of deletion commands sent."})
    private MutableCounterLong deletionCmdsSentTotal;
    @Metric(value={"Number of container replicas deleted successfully."})
    private MutableCounterLong replicasDeletedTotal;
    @Metric(value={"Number of container replicas which timed out before being deleted."})
    private MutableCounterLong replicaDeleteTimeoutTotal;
    @Metric(value={"Number of replication bytes total."})
    private MutableCounterLong replicationBytesTotal;
    @Metric(value={"Number of replication bytes completed."})
    private MutableCounterLong replicationBytesCompletedTotal;
    @Metric(value={"Number of deletion bytes total."})
    private MutableCounterLong deletionBytesTotal;
    @Metric(value={"Number of deletion bytes completed."})
    private MutableCounterLong deletionBytesCompletedTotal;
    @Metric(value={"Time elapsed for replication"})
    private MutableRate replicationTime;
    @Metric(value={"Time elapsed for deletion"})
    private MutableRate deletionTime;
    @Metric(value={"Number of inflight replication skipped due to the configured limit."})
    private MutableCounterLong inflightReplicationSkippedTotal;
    @Metric(value={"Number of inflight replication skipped due to the configured limit."})
    private MutableCounterLong inflightDeletionSkippedTotal;
    @Metric(value={"Number of times under replication processing has paused due to reaching the cluster inflight replication limit."})
    private MutableCounterLong pendingReplicationLimitReachedTotal;
    private MetricsRegistry registry = new MetricsRegistry(METRICS_SOURCE_NAME);
    private final ReplicationManager replicationManager;
    private final boolean legacyReplicationManager;
    @Metric(value={"Number of EC Replication commands sent."})
    private MutableCounterLong ecReplicationCmdsSentTotal;
    @Metric(value={"Number of EC Replica Deletion commands sent."})
    private MutableCounterLong ecDeletionCmdsSentTotal;
    @Metric(value={"Number of EC Reconstruction commands sent."})
    private MutableCounterLong ecReconstructionCmdsSentTotal;
    @Metric(value={"Number of EC replicas successfully created by Replication Manager."})
    private MutableCounterLong ecReplicasCreatedTotal;
    @Metric(value={"Number of EC replicas successfully deleted by Replication Manager."})
    private MutableCounterLong ecReplicasDeletedTotal;
    @Metric(value={"Number of EC replicas scheduled to be created which timed out."})
    private MutableCounterLong ecReplicaCreateTimeoutTotal;
    @Metric(value={"Number of EC replicas scheduled for delete which timed out."})
    private MutableCounterLong ecReplicaDeleteTimeoutTotal;
    @Metric(value={"Number of times partial EC reconstruction was needed due to overloaded nodes, but skipped as there was still sufficient redundancy."})
    private MutableCounterLong ecPartialReconstructionSkippedTotal;
    @Metric(value={"Number of times partial EC reconstruction was used due to insufficient nodes available and reconstruction was critical."})
    private MutableCounterLong ecPartialReconstructionCriticalTotal;
    @Metric(value={"Number of times partial EC reconstruction was used due to insufficient nodes available and with no overloaded nodes."})
    private MutableCounterLong ecPartialReconstructionNoneOverloadedTotal;
    @Metric(value={"Number of times EC decommissioning or entering maintenance mode replicas were not all replicated due to insufficient nodes available."})
    private MutableCounterLong ecPartialReplicationForOutOfServiceReplicasTotal;
    @Metric(value={"Number of times partial Ratis replication occurred due to insufficient nodes available."})
    private MutableCounterLong partialReplicationTotal;
    @Metric(value={"Number of times partial replication occurred to fix a mis-replicated ratis container due to insufficient nodes available."})
    private MutableCounterLong partialReplicationForMisReplicationTotal;
    @Metric(value={"Number of times partial replication occurred to fix a mis-replicated EC container due to insufficient nodes available."})
    private MutableCounterLong ecPartialReplicationForMisReplicationTotal;
    @Metric(value={"NUmber of Reconstruct EC Container commands that could not be sent due to the pending commands on the target datanode"})
    private MutableCounterLong ecReconstructionCmdsDeferredTotal;
    @Metric(value={"Number of delete container commands that could not be sent due to the pending commands on the target datanode"})
    private MutableCounterLong deleteContainerCmdsDeferredTotal;
    @Metric(value={"Number of replicate container commands that could not be sent due to the pending commands on all source datanodes"})
    private MutableCounterLong replicateContainerCmdsDeferredTotal;

    public ReplicationManagerMetrics(ReplicationManager manager) {
        this.replicationManager = manager;
        this.legacyReplicationManager = this.replicationManager.getConfig().isLegacyEnabled();
    }

    public static ReplicationManagerMetrics create(ReplicationManager manager) {
        ReplicationManagerMetrics replicationManagerMetrics = (ReplicationManagerMetrics)DefaultMetricsSystem.instance().getSource(METRICS_SOURCE_NAME);
        if (replicationManagerMetrics == null) {
            return (ReplicationManagerMetrics)DefaultMetricsSystem.instance().register(METRICS_SOURCE_NAME, "SCM Replication manager (closed container replication) related metrics", (Object)new ReplicationManagerMetrics(manager));
        }
        return replicationManagerMetrics;
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(METRICS_SOURCE_NAME).addGauge(INFLIGHT_REPLICATION, this.getInflightReplication()).addGauge(INFLIGHT_DELETION, this.getInflightDeletion()).addGauge(INFLIGHT_EC_REPLICATION, this.getEcReplication()).addGauge(INFLIGHT_EC_DELETION, this.getEcDeletion());
        if (this.legacyReplicationManager) {
            builder.addGauge(INFLIGHT_REPLICATION_SKIPPED, this.getInflightReplicationSkipped()).addGauge(INFLIGHT_DELETION_SKIPPED, this.getInflightDeletionSkipped()).addGauge(INFLIGHT_MOVE, this.getInflightMove());
        }
        if (!this.legacyReplicationManager) {
            builder.addGauge(UNDER_REPLICATED_QUEUE, this.replicationManager.getQueue().underReplicatedQueueSize()).addGauge(OVER_REPLICATED_QUEUE, this.replicationManager.getQueue().overReplicatedQueueSize());
        }
        ReplicationManagerReport report = this.replicationManager.getContainerReport();
        for (Map.Entry<HddsProtos.LifeCycleState, MetricsInfo> entry : LIFECYCLE_STATE_METRICS.entrySet()) {
            builder.addGauge(entry.getValue(), report.getStat(entry.getKey()));
        }
        for (Map.Entry<HddsProtos.LifeCycleState, MetricsInfo> entry : CONTAINER_HEALTH_STATE_METRICS.entrySet()) {
            builder.addGauge(entry.getValue(), report.getStat((ReplicationManagerReport.HealthState)entry.getKey()));
        }
        this.replicationCmdsSentTotal.snapshot(builder, all);
        this.replicasCreatedTotal.snapshot(builder, all);
        this.replicaCreateTimeoutTotal.snapshot(builder, all);
        this.deletionCmdsSentTotal.snapshot(builder, all);
        this.replicasDeletedTotal.snapshot(builder, all);
        this.replicaDeleteTimeoutTotal.snapshot(builder, all);
        if (this.legacyReplicationManager) {
            this.replicationBytesTotal.snapshot(builder, all);
            this.replicationBytesCompletedTotal.snapshot(builder, all);
            this.deletionBytesTotal.snapshot(builder, all);
            this.deletionBytesCompletedTotal.snapshot(builder, all);
            this.replicationTime.snapshot(builder, all);
            this.deletionTime.snapshot(builder, all);
        }
        this.ecReplicationCmdsSentTotal.snapshot(builder, all);
        this.ecDeletionCmdsSentTotal.snapshot(builder, all);
        this.ecReplicasCreatedTotal.snapshot(builder, all);
        this.ecReplicasDeletedTotal.snapshot(builder, all);
        this.ecReconstructionCmdsSentTotal.snapshot(builder, all);
        this.ecReplicaCreateTimeoutTotal.snapshot(builder, all);
        this.ecReplicasDeletedTotal.snapshot(builder, all);
        this.ecReplicaDeleteTimeoutTotal.snapshot(builder, all);
        this.ecReconstructionCmdsDeferredTotal.snapshot(builder, all);
        this.deleteContainerCmdsDeferredTotal.snapshot(builder, all);
        this.replicateContainerCmdsDeferredTotal.snapshot(builder, all);
        this.pendingReplicationLimitReachedTotal.snapshot(builder, all);
        this.ecPartialReconstructionSkippedTotal.snapshot(builder, all);
        this.ecPartialReconstructionCriticalTotal.snapshot(builder, all);
        this.ecPartialReconstructionNoneOverloadedTotal.snapshot(builder, all);
        this.ecPartialReplicationForOutOfServiceReplicasTotal.snapshot(builder, all);
        this.partialReplicationTotal.snapshot(builder, all);
        this.ecPartialReplicationForMisReplicationTotal.snapshot(builder, all);
        this.partialReplicationForMisReplicationTotal.snapshot(builder, all);
    }

    public void unRegister() {
        DefaultMetricsSystem.instance().unregisterSource(METRICS_SOURCE_NAME);
    }

    public void incrReplicationCmdsSentTotal() {
        this.replicationCmdsSentTotal.incr();
    }

    public void incrReplicasCreatedTotal() {
        this.replicasCreatedTotal.incr();
    }

    public void incrReplicaCreateTimeoutTotal() {
        this.replicaCreateTimeoutTotal.incr();
    }

    public void incrDeletionCmdsSentTotal() {
        this.deletionCmdsSentTotal.incr();
    }

    public void incrReplicasDeletedTotal() {
        this.replicasDeletedTotal.incr();
    }

    public void incrReplicaDeleteTimeoutTotal() {
        this.replicaDeleteTimeoutTotal.incr();
    }

    public void incrReplicationBytesTotal(long bytes) {
        this.replicationBytesTotal.incr(bytes);
    }

    public void incrReplicationBytesCompletedTotal(long bytes) {
        this.replicationBytesCompletedTotal.incr(bytes);
    }

    public void incrDeletionBytesTotal(long bytes) {
        this.deletionBytesTotal.incr(bytes);
    }

    public void incrDeletionBytesCompletedTotal(long bytes) {
        this.deletionBytesCompletedTotal.incr(bytes);
    }

    public void addReplicationTime(long millis) {
        this.replicationTime.add(millis);
    }

    public void addDeletionTime(long millis) {
        this.deletionTime.add(millis);
    }

    public void incrInflightSkipped(InflightType type) {
        switch (type) {
            case REPLICATION: {
                this.inflightReplicationSkippedTotal.incr();
                return;
            }
            case DELETION: {
                this.inflightDeletionSkippedTotal.incr();
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected type " + (Object)((Object)type));
    }

    public long getInflightReplication() {
        if (this.legacyReplicationManager) {
            return this.replicationManager.getLegacyReplicationManager().getInflightCount(InflightType.REPLICATION);
        }
        return this.replicationManager.getContainerReplicaPendingOps().getPendingOpCount(ContainerReplicaOp.PendingOpType.ADD, ReplicationType.RATIS);
    }

    public long getInflightReplicationSkipped() {
        return this.inflightReplicationSkippedTotal.value();
    }

    public long getInflightDeletion() {
        if (this.legacyReplicationManager) {
            return this.replicationManager.getLegacyReplicationManager().getInflightCount(InflightType.DELETION);
        }
        return this.replicationManager.getContainerReplicaPendingOps().getPendingOpCount(ContainerReplicaOp.PendingOpType.DELETE, ReplicationType.RATIS);
    }

    public long getInflightDeletionSkipped() {
        return this.inflightDeletionSkippedTotal.value();
    }

    public long getInflightMove() {
        return this.replicationManager.getInflightMove().size();
    }

    public long getReplicationCmdsSentTotal() {
        return this.replicationCmdsSentTotal.value();
    }

    public long getReplicasCreatedTotal() {
        return this.replicasCreatedTotal.value();
    }

    public long getReplicaCreateTimeoutTotal() {
        return this.replicaCreateTimeoutTotal.value();
    }

    public long getDeletionCmdsSentTotal() {
        return this.deletionCmdsSentTotal.value();
    }

    public long getReplicasDeletedTotal() {
        return this.replicasDeletedTotal.value();
    }

    public long getReplicaDeleteTimeoutTotal() {
        return this.replicaDeleteTimeoutTotal.value();
    }

    public long getDeletionBytesTotal() {
        return this.deletionBytesTotal.value();
    }

    public long getDeletionBytesCompletedTotal() {
        return this.deletionBytesCompletedTotal.value();
    }

    public long getReplicationBytesTotal() {
        return this.replicationBytesTotal.value();
    }

    public long getReplicationBytesCompletedTotal() {
        return this.replicationBytesCompletedTotal.value();
    }

    public void incrEcReplicationCmdsSentTotal() {
        this.ecReplicationCmdsSentTotal.incr();
    }

    public void incrEcDeletionCmdsSentTotal() {
        this.ecDeletionCmdsSentTotal.incr();
    }

    public void incrEcReplicasCreatedTotal() {
        this.ecReplicasCreatedTotal.incr();
    }

    public void incrEcReplicasDeletedTotal() {
        this.ecReplicasDeletedTotal.incr();
    }

    public void incrEcReconstructionCmdsSentTotal() {
        this.ecReconstructionCmdsSentTotal.incr();
    }

    public void incrECReconstructionCmdsDeferredTotal() {
        this.ecReconstructionCmdsDeferredTotal.incr();
    }

    public void incrDeleteContainerCmdsDeferredTotal() {
        this.deleteContainerCmdsDeferredTotal.incr();
    }

    public void incrReplicateContainerCmdsDeferredTotal() {
        this.replicateContainerCmdsDeferredTotal.incr();
    }

    public long getEcReplication() {
        return this.replicationManager.getContainerReplicaPendingOps().getPendingOpCount(ContainerReplicaOp.PendingOpType.ADD, ReplicationType.EC);
    }

    public long getEcDeletion() {
        return this.replicationManager.getContainerReplicaPendingOps().getPendingOpCount(ContainerReplicaOp.PendingOpType.DELETE, ReplicationType.EC);
    }

    public void incrEcReplicaCreateTimeoutTotal() {
        this.ecReplicaCreateTimeoutTotal.incr();
    }

    public long getEcDeletionCmdsSentTotal() {
        return this.ecDeletionCmdsSentTotal.value();
    }

    public long getEcReconstructionCmdsSentTotal() {
        return this.ecReconstructionCmdsSentTotal.value();
    }

    public long getEcReplicationCmdsSentTotal() {
        return this.ecReplicationCmdsSentTotal.value();
    }

    public void incrEcReplicaDeleteTimeoutTotal() {
        this.ecReplicaDeleteTimeoutTotal.incr();
    }

    public long getEcReplicaCreateTimeoutTotal() {
        return this.ecReplicaCreateTimeoutTotal.value();
    }

    public long getEcReplicaDeleteTimeoutTotal() {
        return this.ecReplicaDeleteTimeoutTotal.value();
    }

    public long getEcReplicasCreatedTotal() {
        return this.ecReplicasCreatedTotal.value();
    }

    public long getEcReplicasDeletedTotal() {
        return this.ecReplicasDeletedTotal.value();
    }

    public long getEcReconstructionCmdsDeferredTotal() {
        return this.ecReconstructionCmdsDeferredTotal.value();
    }

    public long getDeleteContainerCmdsDeferredTotal() {
        return this.deleteContainerCmdsDeferredTotal.value();
    }

    public long getReplicateContainerCmdsDeferredTotal() {
        return this.replicateContainerCmdsDeferredTotal.value();
    }

    public void incrPendingReplicationLimitReachedTotal() {
        this.pendingReplicationLimitReachedTotal.incr();
    }

    public long getPendingReplicationLimitReachedTotal() {
        return this.pendingReplicationLimitReachedTotal.value();
    }

    public long getECPartialReconstructionSkippedTotal() {
        return this.ecPartialReconstructionSkippedTotal.value();
    }

    public void incrECPartialReconstructionSkippedTotal() {
        this.ecPartialReconstructionSkippedTotal.incr();
    }

    public long getECPartialReconstructionCriticalTotal() {
        return this.ecPartialReconstructionCriticalTotal.value();
    }

    public void incrECPartialReconstructionCriticalTotal() {
        this.ecPartialReconstructionCriticalTotal.incr();
    }

    public long getEcPartialReconstructionNoneOverloadedTotal() {
        return this.ecPartialReconstructionNoneOverloadedTotal.value();
    }

    public void incrEcPartialReconstructionNoneOverloadedTotal() {
        this.ecPartialReconstructionNoneOverloadedTotal.incr();
    }

    public long getEcPartialReplicationForOutOfServiceReplicasTotal() {
        return this.ecPartialReplicationForOutOfServiceReplicasTotal.value();
    }

    public void incrEcPartialReplicationForOutOfServiceReplicasTotal() {
        this.ecPartialReplicationForOutOfServiceReplicasTotal.incr();
    }

    public long getPartialReplicationTotal() {
        return this.partialReplicationTotal.value();
    }

    public void incrPartialReplicationTotal() {
        this.partialReplicationTotal.incr();
    }

    public void incrEcPartialReplicationForMisReplicationTotal() {
        this.ecPartialReplicationForMisReplicationTotal.incr();
    }

    public long getEcPartialReplicationForMisReplicationTotal() {
        return this.ecPartialReplicationForMisReplicationTotal.value();
    }

    public void incrPartialReplicationForMisReplicationTotal() {
        this.partialReplicationForMisReplicationTotal.incr();
    }

    public long getPartialReplicationForMisReplicationTotal() {
        return this.partialReplicationForMisReplicationTotal.value();
    }
}

