/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletingContainerHandler
extends AbstractCheck {
    private final ReplicationManager replicationManager;
    public static final Logger LOG = LoggerFactory.getLogger(DeletingContainerHandler.class);

    public DeletingContainerHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        ContainerInfo containerInfo = request.getContainerInfo();
        ContainerID cID = containerInfo.containerID();
        HddsProtos.LifeCycleState containerState = containerInfo.getState();
        if (containerState == HddsProtos.LifeCycleState.DELETED) {
            LOG.debug("Container {} is DELETED so returning true", (Object)containerInfo);
            return true;
        }
        if (containerState != HddsProtos.LifeCycleState.DELETING) {
            return false;
        }
        LOG.debug("Checking container {} in DeletingContainerHandler", (Object)containerInfo);
        if (request.isReadOnly()) {
            return true;
        }
        if (request.getContainerReplicas().size() == 0) {
            LOG.debug("Deleting Container {} has no replicas so marking for cleanup and returning true", (Object)containerInfo);
            this.replicationManager.updateContainerState(cID, HddsProtos.LifeCycleEvent.CLEANUP);
            return true;
        }
        Set pendingDelete = request.getPendingOps().stream().filter(o -> o.getOpType() == ContainerReplicaOp.PendingOpType.DELETE).map(ContainerReplicaOp::getTarget).collect(Collectors.toSet());
        request.getContainerReplicas().stream().filter(r -> !pendingDelete.contains(r.getDatanodeDetails())).forEach(rp -> {
            try {
                this.replicationManager.sendDeleteCommand(containerInfo, rp.getReplicaIndex(), rp.getDatanodeDetails(), false);
            }
            catch (NotLeaderException e) {
                LOG.warn("Failed to delete empty replica with index {} for container {} on datanode {}", new Object[]{rp.getReplicaIndex(), cID, rp.getDatanodeDetails().getUuidString(), e});
            }
        });
        return true;
    }
}

