/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.states;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerAttribute<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerAttribute.class);
    private final Map<T, NavigableSet<ContainerID>> attributeMap;
    private static final NavigableSet<ContainerID> EMPTY_SET = Collections.unmodifiableNavigableSet(new ConcurrentSkipListSet());

    public ContainerAttribute(Map<T, NavigableSet<ContainerID>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public ContainerAttribute() {
        this.attributeMap = new ConcurrentHashMap<T, NavigableSet<ContainerID>>();
    }

    public boolean insert(T key, ContainerID value) throws SCMException {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull((Object)value);
        this.attributeMap.computeIfAbsent(key, any -> new ConcurrentSkipListSet()).add(value);
        return true;
    }

    public boolean hasKey(T key) {
        Preconditions.checkNotNull(key);
        return this.attributeMap.containsKey(key);
    }

    public boolean hasContainerID(T key, ContainerID id) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull((Object)id);
        return this.attributeMap.containsKey(key) && this.attributeMap.get(key).contains(id);
    }

    public boolean hasContainerID(T key, int id) {
        return this.hasContainerID(key, ContainerID.valueOf((long)id));
    }

    public void clearSet(T key) {
        Preconditions.checkNotNull(key);
        if (this.attributeMap.containsKey(key)) {
            this.attributeMap.get(key).clear();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("key: {} does not exist in the attributeMap", key);
        }
    }

    public boolean remove(T key, ContainerID value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull((Object)value);
        if (this.attributeMap.containsKey(key)) {
            if (!this.attributeMap.get(key).remove(value)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ContainerID: {} does not exist in the set pointed by key:{}", (Object)value, key);
                }
                return false;
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("key: {} does not exist in the attributeMap", key);
        }
        return false;
    }

    public NavigableSet<ContainerID> getCollection(T key) {
        Preconditions.checkNotNull(key);
        if (this.attributeMap.containsKey(key)) {
            return ImmutableSortedSet.copyOf((Collection)this.attributeMap.get(key));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No such Key. Key {}", key);
        }
        return EMPTY_SET;
    }

    public void update(T currentKey, T newKey, ContainerID value) throws SCMException {
        Preconditions.checkNotNull(currentKey);
        Preconditions.checkNotNull(newKey);
        if (currentKey == newKey) {
            return;
        }
        boolean removed = false;
        try {
            removed = this.remove(currentKey, value);
            if (!removed) {
                throw new SCMException("Unable to find key in the current key bucket", SCMException.ResultCodes.FAILED_TO_CHANGE_CONTAINER_STATE);
            }
            this.insert(newKey, value);
        }
        catch (SCMException ex) {
            LOG.error("error in update.", (Throwable)ex);
            if (removed) {
                this.insert(currentKey, value);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("reinserted the removed key. {}", currentKey);
                }
            }
            throw ex;
        }
    }
}

