/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionUtil<E extends Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionUtil.class);
    private final CheckedRunnable<E> fn;
    private CheckedRunnable<E> onException;
    private volatile boolean completed;

    private ExecutionUtil(CheckedRunnable<E> fn) {
        this.fn = fn;
        this.completed = false;
    }

    public static <E extends Exception> ExecutionUtil<E> create(CheckedRunnable<E> tryBlock) {
        return new ExecutionUtil<E>(tryBlock);
    }

    public ExecutionUtil<E> onException(CheckedRunnable<E> catchBlock) {
        this.onException = catchBlock;
        return this;
    }

    public void execute() throws E {
        if (!this.completed) {
            this.completed = true;
            try {
                this.fn.run();
            }
            catch (Exception ex) {
                try {
                    this.onException.run();
                }
                catch (Exception error) {
                    LOG.warn("Got error while doing clean-up.", (Throwable)error);
                }
                throw ex;
            }
        }
    }
}

