/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.scm.proto.InterSCMProtocolProtos;
import org.apache.hadoop.hdds.protocol.scm.proto.InterSCMProtocolServiceGrpc;
import org.apache.hadoop.hdds.scm.ha.SCMSnapshotDownloader;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.ssl.KeyStoresFactory;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterSCMGrpcClient
implements SCMSnapshotDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(InterSCMGrpcClient.class);
    private final ManagedChannel channel;
    private final InterSCMProtocolServiceGrpc.InterSCMProtocolServiceStub client;
    private final long timeout;

    public InterSCMGrpcClient(String host, int port, ConfigurationSource conf, CertificateClient scmCertificateClient) throws IOException {
        Preconditions.checkNotNull((Object)conf);
        this.timeout = conf.getTimeDuration("ozone.scm.ha.grpc.deadline.interval", 1800000L, TimeUnit.MILLISECONDS);
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port).usePlaintext().maxInboundMessageSize(0x2000000);
        SecurityConfig securityConfig = new SecurityConfig(conf);
        if (securityConfig.isSecurityEnabled() && securityConfig.isGrpcTlsEnabled()) {
            SslContextBuilder sslClientContextBuilder = SslContextBuilder.forClient();
            KeyStoresFactory keyStoreFactory = scmCertificateClient.getClientKeyStoresFactory();
            sslClientContextBuilder.keyManager(keyStoreFactory.getKeyManagers()[0]);
            sslClientContextBuilder.trustManager(keyStoreFactory.getTrustManagers()[0]);
            SslContextBuilder sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)securityConfig.getGrpcSslProvider());
            channelBuilder.sslContext(sslContextBuilder.build()).useTransportSecurity();
        }
        this.channel = channelBuilder.build();
        this.client = (InterSCMProtocolServiceGrpc.InterSCMProtocolServiceStub)InterSCMProtocolServiceGrpc.newStub((Channel)this.channel).withDeadlineAfter(this.timeout, TimeUnit.SECONDS);
    }

    @Override
    public CompletableFuture<Path> download(Path outputPath) {
        InterSCMProtocolProtos.CopyDBCheckpointRequestProto request = InterSCMProtocolProtos.CopyDBCheckpointRequestProto.newBuilder().setFlush(true).build();
        CompletableFuture<Path> response = new CompletableFuture<Path>();
        this.client.download(request, (StreamObserver)new StreamDownloader(response, outputPath));
        return response;
    }

    public void shutdown() {
        this.channel.shutdown();
        try {
            this.channel.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("failed to shutdown replication channel", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public static class StreamDownloader
    implements StreamObserver<InterSCMProtocolProtos.CopyDBCheckpointResponseProto> {
        private final CompletableFuture<Path> response;
        private final OutputStream stream;
        private final Path outputPath;

        public StreamDownloader(CompletableFuture<Path> response, Path outputPath) {
            this.response = response;
            this.outputPath = outputPath;
            try {
                Preconditions.checkNotNull((Object)outputPath, (Object)"Output path cannot be null");
                this.stream = new FileOutputStream(outputPath.toFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Output path can't be used: " + outputPath, e);
            }
        }

        public void onNext(InterSCMProtocolProtos.CopyDBCheckpointResponseProto checkPoint) {
            try {
                checkPoint.getData().writeTo(this.stream);
            }
            catch (IOException e) {
                this.onError(e);
            }
        }

        public void onError(Throwable throwable) {
            try {
                LOG.error("Download of checkpoint {} was unsuccessful", (Object)this.outputPath, (Object)throwable);
                this.stream.close();
                this.deleteOutputOnFailure();
                this.response.completeExceptionally(throwable);
            }
            catch (IOException e) {
                LOG.error("Failed to close {}}", (Object)this.outputPath, (Object)e);
                this.response.completeExceptionally(e);
            }
        }

        public void onCompleted() {
            try {
                this.stream.close();
                LOG.info("Checkpoint is downloaded to {}", (Object)this.outputPath);
                this.response.complete(this.outputPath);
            }
            catch (IOException e) {
                LOG.error("Downloaded checkpoint OK, but failed to close {}", (Object)this.outputPath, (Object)e);
                this.response.completeExceptionally(e);
            }
        }

        private void deleteOutputOnFailure() {
            try {
                Files.delete(this.outputPath);
            }
            catch (IOException ex) {
                LOG.error("Failed to delete destination {} for unsuccessful download", (Object)this.outputPath, (Object)ex);
            }
        }
    }
}

