/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;

@Metrics(about="SCM HA metrics", context="ozone")
public final class SCMHAMetrics
implements MetricsSource {
    private static final String SOURCE_NAME = SCMHAMetrics.class.getSimpleName();
    private final SCMHAMetricsInfo scmHAMetricsInfo = new SCMHAMetricsInfo();
    private final String currNodeId;
    private final String leaderId;

    private SCMHAMetrics(String currNodeId, String leaderId) {
        this.currNodeId = currNodeId;
        this.leaderId = leaderId;
    }

    public static SCMHAMetrics create(String nodeId, String leaderId) {
        SCMHAMetrics metrics = new SCMHAMetrics(nodeId, leaderId);
        return (SCMHAMetrics)DefaultMetricsSystem.instance().register(SOURCE_NAME, "SCM HA metrics", (Object)metrics);
    }

    public static void unRegister() {
        DefaultMetricsSystem.instance().unregisterSource(SOURCE_NAME);
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        int state = this.currNodeId.equals(this.leaderId) ? 1 : 0;
        this.scmHAMetricsInfo.setNodeId(this.currNodeId);
        this.scmHAMetricsInfo.setScmHALeaderState(state);
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME);
        recordBuilder.tag(SCMHAMetricsInfo.NODE_ID, this.currNodeId).addGauge(SCMHAMetricsInfo.SCM_MANAGER_HA_LEADER_STATE, state);
        recordBuilder.endRecord();
    }

    @VisibleForTesting
    public String getSCMHAMetricsInfoNodeId() {
        return this.scmHAMetricsInfo.getNodeId();
    }

    @VisibleForTesting
    public int getSCMHAMetricsInfoLeaderState() {
        return this.scmHAMetricsInfo.getScmHALeaderState();
    }

    private static final class SCMHAMetricsInfo {
        private static final MetricsInfo SCM_MANAGER_HA_LEADER_STATE = Interns.info((String)"SCMHALeaderState", (String)"Leader active state of SCM node (1 leader, 0 follower");
        private static final MetricsInfo NODE_ID = Interns.info((String)"NodeId", (String)"SCM node Id");
        private int scmHALeaderState;
        private String nodeId;

        private SCMHAMetricsInfo() {
        }

        public int getScmHALeaderState() {
            return this.scmHALeaderState;
        }

        public void setScmHALeaderState(int scmHALeaderState) {
            this.scmHALeaderState = scmHALeaderState;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }
    }
}

