/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha.io;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.hdds.scm.ha.io.BigIntegerCodec;
import org.apache.hadoop.hdds.scm.ha.io.BooleanCodec;
import org.apache.hadoop.hdds.scm.ha.io.ByteStringCodec;
import org.apache.hadoop.hdds.scm.ha.io.Codec;
import org.apache.hadoop.hdds.scm.ha.io.EnumCodec;
import org.apache.hadoop.hdds.scm.ha.io.GeneratedMessageCodec;
import org.apache.hadoop.hdds.scm.ha.io.IntegerCodec;
import org.apache.hadoop.hdds.scm.ha.io.ListCodec;
import org.apache.hadoop.hdds.scm.ha.io.LongCodec;
import org.apache.hadoop.hdds.scm.ha.io.ManagedSecretKeyCodec;
import org.apache.hadoop.hdds.scm.ha.io.StringCodec;
import org.apache.hadoop.hdds.scm.ha.io.X509CertificateCodec;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;

public final class CodecFactory {
    private static Map<Class<?>, Codec> codecs = new HashMap();

    private CodecFactory() {
    }

    public static Codec getCodec(Class<?> type) throws InvalidProtocolBufferException {
        ArrayList classes = new ArrayList();
        classes.add(type);
        classes.addAll(ClassUtils.getAllSuperclasses(type));
        classes.addAll(ClassUtils.getAllInterfaces(type));
        for (Class clazz : classes) {
            if (!codecs.containsKey(clazz)) continue;
            return codecs.get(clazz);
        }
        throw new InvalidProtocolBufferException("Codec for " + type + " not found!");
    }

    static {
        codecs.put(Message.class, new GeneratedMessageCodec());
        codecs.put(ProtocolMessageEnum.class, new EnumCodec());
        codecs.put(List.class, new ListCodec());
        codecs.put(Integer.class, new IntegerCodec());
        codecs.put(Long.class, new LongCodec());
        codecs.put(String.class, new StringCodec());
        codecs.put(Boolean.class, new BooleanCodec());
        codecs.put(BigInteger.class, new BigIntegerCodec());
        codecs.put(X509Certificate.class, new X509CertificateCodec());
        codecs.put(ByteString.class, new ByteStringCodec());
        codecs.put(ManagedSecretKey.class, new ManagedSecretKeyCodec());
    }
}

