/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.security;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(name="Root CA Rotation Metrics", about="Metrics related to Root CA rotation in SCM", context="SCM")
public final class RootCARotationMetrics {
    public static final String NAME = RootCARotationMetrics.class.getSimpleName();
    private final MetricsSystem ms;
    @Metric(about="Number of total tries, both successes and failures.")
    private MutableCounterLong numTotalRotation;
    @Metric(about="Number of successful rotations")
    private MutableCounterLong numSuccessRotation;
    @Metric(about="Time(nano second) spent on last successful rotation")
    private MutableGaugeLong successTimeInNs;

    public static RootCARotationMetrics create() {
        MetricsSystem metricsSystem = DefaultMetricsSystem.instance();
        return (RootCARotationMetrics)metricsSystem.register(NAME, "Root CA Rotation Metrics", (Object)new RootCARotationMetrics(metricsSystem));
    }

    public void unRegister() {
        MetricsSystem metricsSystem = DefaultMetricsSystem.instance();
        metricsSystem.unregisterSource(NAME);
    }

    private RootCARotationMetrics(MetricsSystem ms) {
        this.ms = ms;
    }

    public MutableGaugeLong getSuccessTimeInNs() {
        return this.successTimeInNs;
    }

    public void setSuccessTimeInNs(long time) {
        this.successTimeInNs.set(time);
    }

    public void incrSuccessRotationNum() {
        this.numSuccessRotation.incr();
    }

    public void incrTotalRotationNum() {
        this.numTotalRotation.incr();
    }

    public long getSuccessRotationNum() {
        return this.numSuccessRotation.value();
    }

    public long getTotalRotationNum() {
        return this.numTotalRotation.value();
    }
}

